/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi.types.channel.operation.message.header;

import com.google.common.collect.ImmutableList;
import io.github.stavshamir.springwolf.asyncapi.types.channel.operation.message.header.AsyncHeaderSchema;
import io.github.stavshamir.springwolf.asyncapi.types.channel.operation.message.header.AsyncHeaders;
import java.util.List;

public class AsyncHeadersForSpringKafkaBuilder {
    private final AsyncHeaders headers;

    public AsyncHeadersForSpringKafkaBuilder() {
        this("SpringKafkaDefaultHeaders");
    }

    public AsyncHeadersForSpringKafkaBuilder(String schemaName) {
        this.headers = new AsyncHeaders(schemaName);
    }

    public AsyncHeadersForSpringKafkaBuilder withTypeIdHeader(String exampleTypeId) {
        return this.withTypeIdHeader(exampleTypeId, (List<String>)ImmutableList.of((Object)exampleTypeId));
    }

    public AsyncHeadersForSpringKafkaBuilder withTypeIdHeader(String exampleTypeId, List<String> types) {
        return this.withHeader("__TypeId__", types, exampleTypeId, "Spring Type Id Header");
    }

    private AsyncHeadersForSpringKafkaBuilder withHeader(String headerName, List<String> types, String exampleType, String description) {
        AsyncHeaderSchema header = AsyncHeaderSchema.headerBuilder().headerName(headerName).description(description).example(exampleType).enumValue(types).build();
        this.headers.addHeader(header);
        return this;
    }

    public AsyncHeaders build() {
        return AsyncHeaders.from((AsyncHeaders)this.headers, (String)this.headers.getSchemaName());
    }
}

