/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.producer;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;

public class SpringwolfKafkaProducer {
    private static final Logger log = LoggerFactory.getLogger(SpringwolfKafkaProducer.class);
    private final Optional<KafkaTemplate<Object, Map<String, ?>>> kafkaTemplate;

    public boolean isEnabled() {
        return this.kafkaTemplate.isPresent();
    }

    public void send(String topic, Map<String, String> headers, Map<String, ?> payload) {
        if (this.kafkaTemplate.isPresent()) {
            this.kafkaTemplate.get().send(this.buildProducerRecord(topic, headers, payload));
        } else {
            log.warn("Kafka producer is not configured");
        }
    }

    private ProducerRecord<Object, Map<String, ?>> buildProducerRecord(String topic, Map<String, String> headers, Map<String, ?> payload) {
        List recordHeaders = headers != null ? this.buildHeaders(headers) : Collections.emptyList();
        return new ProducerRecord(topic, null, null, null, payload, recordHeaders);
    }

    private List<Header> buildHeaders(Map<String, String> headers) {
        return headers.entrySet().stream().map(header -> new RecordHeader((String)header.getKey(), ((String)header.getValue()).getBytes(StandardCharsets.UTF_8))).collect(Collectors.toList());
    }

    public SpringwolfKafkaProducer(Optional<KafkaTemplate<Object, Map<String, ?>>> kafkaTemplate) {
        this.kafkaTemplate = kafkaTemplate;
    }
}

