/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi.scanners.channels.operationdata;

import com.asyncapi.v2.binding.OperationBinding;
import com.asyncapi.v2.binding.kafka.KafkaOperationBinding;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.operationdata.ProcessedOperationBinding;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.operationdata.annotation.KafkaAsyncOperationBinding;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.operationdata.annotation.OperationBindingProcessor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

@Component
public class KafkaOperationBindingProcessor
implements OperationBindingProcessor,
EmbeddedValueResolverAware {
    private StringValueResolver resolver;

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.resolver = resolver;
    }

    public Optional<ProcessedOperationBinding> process(Method method) {
        return Arrays.stream(method.getAnnotations()).filter(annotation -> annotation instanceof KafkaAsyncOperationBinding).map(annotation -> (KafkaAsyncOperationBinding)annotation).findAny().map(this::mapToOperationBinding);
    }

    private ProcessedOperationBinding mapToOperationBinding(KafkaAsyncOperationBinding bindingAnnotation) {
        KafkaOperationBinding kafkaOperationBinding = KafkaOperationBinding.builder().bindingVersion(this.resolveOrNull(bindingAnnotation.bindingVersion())).clientId((Object)this.resolveOrNull(bindingAnnotation.clientId())).groupId((Object)this.resolveOrNull(bindingAnnotation.groupId())).build();
        return new ProcessedOperationBinding(bindingAnnotation.type(), (OperationBinding)kafkaOperationBinding);
    }

    private String resolveOrNull(String stringValue) {
        return StringUtils.isEmpty((Object)stringValue) ? null : this.resolver.resolveStringValue(stringValue);
    }
}

