/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.configuration;

import com.asyncapi.v2.model.server.Server;
import com.google.common.collect.ImmutableMap;
import io.github.stavshamir.springwolf.configuration.AsyncApiDocket;
import io.github.stavshamir.springwolf.configuration.AsyncApiDocketService;
import io.github.stavshamir.springwolf.configuration.SpringwolfKafkaProducerConfiguration;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.serialization.StringSerializer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.support.serializer.JsonSerializer;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnBean(value={SpringwolfKafkaProducerConfiguration.class})
public class SpringwolfKafkaTemplateFactory {
    private final AsyncApiDocketService asyncApiDocketService;

    public Optional<KafkaTemplate<Object, Map<String, ?>>> buildKafkaTemplate() {
        return this.getBootstrapServers(this.asyncApiDocketService.getAsyncApiDocket()).map(this::buildProducerConfiguration).map(producerConfiguration -> new DefaultKafkaProducerFactory(producerConfiguration)).map(KafkaTemplate::new);
    }

    private Optional<String> getBootstrapServers(AsyncApiDocket docket) {
        return docket.getServers().values().stream().filter(server -> server.getProtocol().equals("kafka")).map(Server::getUrl).findFirst();
    }

    private Map<String, Object> buildProducerConfiguration(String bootstrapServers) {
        return ImmutableMap.of((Object)"bootstrap.servers", (Object)bootstrapServers, (Object)"key.serializer", StringSerializer.class, (Object)"value.serializer", JsonSerializer.class, (Object)"spring.json.add.type.headers", (Object)false);
    }

    public SpringwolfKafkaTemplateFactory(AsyncApiDocketService asyncApiDocketService) {
        this.asyncApiDocketService = asyncApiDocketService;
    }
}

