/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi;

import io.github.stavshamir.springwolf.asyncapi.controller.dtos.MessageDto;
import io.github.stavshamir.springwolf.producer.SpringwolfKafkaProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/springwolf/kafka"})
@ConditionalOnProperty(prefix="springwolf.plugin.kafka", name={"publishing.enabled"})
public class SpringwolfKafkaController {
    private static final Logger log = LoggerFactory.getLogger(SpringwolfKafkaController.class);
    private final SpringwolfKafkaProducer kafkaProducer;

    @PostMapping(value={"/publish"})
    public void publish(@RequestParam String topic, @RequestBody MessageDto message) {
        if (message.getPayload() == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Message payload is required");
        }
        if (!this.kafkaProducer.isEnabled()) {
            log.debug("Kafka producer is not enabled - message will not be published");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Kafka producer is not enabled");
        }
        String kafkaKey = message.getBindings() != null ? (String)message.getBindings().get("key") : null;
        log.debug("Publishing to kafka topic {} with key {}: {}", new Object[]{topic, kafkaKey, message});
        this.kafkaProducer.send(topic, kafkaKey, message.getHeaders(), message.getPayload());
    }

    public SpringwolfKafkaController(SpringwolfKafkaProducer kafkaProducer) {
        this.kafkaProducer = kafkaProducer;
    }
}

