/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi.scanners.channels.operationdata;

import com.asyncapi.v2.binding.operation.OperationBinding;
import com.asyncapi.v2.binding.operation.kafka.KafkaOperationBinding;
import com.asyncapi.v2.schema.Schema;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.annotation.KafkaListenerUtil;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.operationdata.ProcessedOperationBinding;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.operationdata.annotation.KafkaAsyncOperationBinding;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.operationdata.annotation.OperationBindingProcessor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

@Component
public class KafkaOperationBindingProcessor
implements OperationBindingProcessor,
EmbeddedValueResolverAware {
    private StringValueResolver resolver;

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.resolver = resolver;
    }

    public Optional<ProcessedOperationBinding> process(Method method) {
        return Arrays.stream(method.getAnnotations()).filter(annotation -> annotation instanceof KafkaAsyncOperationBinding).map(annotation -> (KafkaAsyncOperationBinding)annotation).findAny().map(this::mapToOperationBinding);
    }

    private ProcessedOperationBinding mapToOperationBinding(KafkaAsyncOperationBinding bindingAnnotation) {
        String clientId = this.resolveOrNull(bindingAnnotation.clientId());
        Schema clientIdSchema = KafkaListenerUtil.buildKafkaClientIdSchema(clientId);
        String groupId = this.resolveOrNull(bindingAnnotation.groupId());
        Schema groupIdSchema = KafkaListenerUtil.buildKafkaGroupIdSchema(groupId);
        KafkaOperationBinding.KafkaOperationBindingBuilder kafkaOperationBindingBuilder = KafkaOperationBinding.builder();
        kafkaOperationBindingBuilder.clientId((Object)clientIdSchema).groupId((Object)groupIdSchema);
        String bindingVersion = this.resolveOrNull(bindingAnnotation.bindingVersion());
        if (StringUtils.hasText((String)bindingVersion)) {
            kafkaOperationBindingBuilder.bindingVersion(bindingVersion);
        }
        return new ProcessedOperationBinding(bindingAnnotation.type(), (OperationBinding)kafkaOperationBindingBuilder.build());
    }

    private String resolveOrNull(String stringValue) {
        return StringUtils.hasText((String)stringValue) ? this.resolver.resolveStringValue(stringValue) : null;
    }
}

