/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi.types;

import com.asyncapi.v2.binding.channel.kafka.KafkaChannelBinding;
import com.asyncapi.v2.binding.message.kafka.KafkaMessageBinding;
import com.asyncapi.v2.binding.operation.kafka.KafkaOperationBinding;
import io.github.stavshamir.springwolf.asyncapi.types.ProducerData;
import io.github.stavshamir.springwolf.asyncapi.types.channel.operation.message.header.AsyncHeaders;
import java.util.Map;

public class KafkaProducerData
extends ProducerData {
    public KafkaProducerData(String topicName, Class<?> payloadType, String description, AsyncHeaders headers) {
        this.channelName = topicName;
        this.description = description;
        this.channelBinding = Map.of("kafka", new KafkaChannelBinding());
        this.payloadType = payloadType;
        this.headers = headers != null ? headers : this.headers;
        this.operationBinding = Map.of("kafka", new KafkaOperationBinding());
        this.messageBinding = Map.of("kafka", new KafkaMessageBinding());
    }

    public static KafkaProducerDataBuilder kafkaProducerDataBuilder() {
        return new KafkaProducerDataBuilder();
    }

    public static class KafkaProducerDataBuilder {
        private String topicName;
        private Class<?> payloadType;
        private String description;
        private AsyncHeaders headers;

        KafkaProducerDataBuilder() {
        }

        public KafkaProducerDataBuilder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public KafkaProducerDataBuilder payloadType(Class<?> payloadType) {
            this.payloadType = payloadType;
            return this;
        }

        public KafkaProducerDataBuilder description(String description) {
            this.description = description;
            return this;
        }

        public KafkaProducerDataBuilder headers(AsyncHeaders headers) {
            this.headers = headers;
            return this;
        }

        public KafkaProducerData build() {
            return new KafkaProducerData(this.topicName, this.payloadType, this.description, this.headers);
        }

        public String toString() {
            return "KafkaProducerData.KafkaProducerDataBuilder(topicName=" + this.topicName + ", payloadType=" + this.payloadType + ", description=" + this.description + ", headers=" + this.headers + ")";
        }
    }
}

