/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi.kafka;

import io.github.stavshamir.springwolf.asyncapi.controller.PublishingPayloadCreator;
import io.github.stavshamir.springwolf.asyncapi.controller.SpringwolfKafkaController;
import io.github.stavshamir.springwolf.configuration.properties.SpringwolfKafkaConfigProperties;
import io.github.stavshamir.springwolf.producer.SpringwolfKafkaProducer;
import io.github.stavshamir.springwolf.producer.SpringwolfKafkaTemplateFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="springwolf.plugin.kafka", name={"publishing.enabled"}, havingValue="true")
public class SpringwolfKafkaProducerConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public SpringwolfKafkaController springwolfKafkaController(PublishingPayloadCreator publishingPayloadCreator, SpringwolfKafkaProducer springwolfKafkaProducer) {
        return new SpringwolfKafkaController(publishingPayloadCreator, springwolfKafkaProducer);
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringwolfKafkaProducer springwolfKafkaProducer(SpringwolfKafkaTemplateFactory producerTemplateFactory) {
        return new SpringwolfKafkaProducer(producerTemplateFactory.buildKafkaTemplate());
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringwolfKafkaTemplateFactory springwolfKafkaTemplateFactory(SpringwolfKafkaConfigProperties springwolfKafkaConfigProperties) {
        return new SpringwolfKafkaTemplateFactory(springwolfKafkaConfigProperties);
    }
}

