/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi.kafka;

import io.github.stavshamir.springwolf.asyncapi.scanners.bindings.processor.KafkaMessageBindingProcessor;
import io.github.stavshamir.springwolf.asyncapi.scanners.bindings.processor.KafkaOperationBindingProcessor;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.annotation.ClassLevelKafkaListenerScanner;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.annotation.MethodLevelKafkaListenerScanner;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.payload.PayloadClassExtractor;
import io.github.stavshamir.springwolf.asyncapi.scanners.classes.ComponentClassScanner;
import io.github.stavshamir.springwolf.schemas.SchemasService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration(proxyBeanMethods=false)
public class SpringwolfKafkaScannerConfiguration {
    @Bean
    @Order(value=3)
    @ConditionalOnProperty(name={"springwolf.plugin.kafka.scanner.kafka-listener.enabled"}, havingValue="true", matchIfMissing=true)
    public ClassLevelKafkaListenerScanner classLevelKafkaListenerScanner(ComponentClassScanner componentClassScanner, SchemasService schemasService, PayloadClassExtractor payloadClassExtractor) {
        return new ClassLevelKafkaListenerScanner(componentClassScanner, schemasService, payloadClassExtractor);
    }

    @Bean
    @Order(value=3)
    @ConditionalOnProperty(name={"springwolf.plugin.kafka.scanner.kafka-listener.enabled"}, havingValue="true", matchIfMissing=true)
    public MethodLevelKafkaListenerScanner methodLevelKafkaListenerScanner(ComponentClassScanner componentClassScanner, SchemasService schemasService, PayloadClassExtractor payloadClassExtractor) {
        return new MethodLevelKafkaListenerScanner(componentClassScanner, schemasService, payloadClassExtractor);
    }

    @Bean
    @Order(value=3)
    @ConditionalOnMissingBean
    public KafkaMessageBindingProcessor kafkaMessageBindingProcessor() {
        return new KafkaMessageBindingProcessor();
    }

    @Bean
    @Order(value=3)
    @ConditionalOnMissingBean
    public KafkaOperationBindingProcessor kafkaOperationBindingProcessor() {
        return new KafkaOperationBindingProcessor();
    }
}

