/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi.scanners.channels.annotation;

import com.asyncapi.v2.binding.channel.ChannelBinding;
import com.asyncapi.v2.binding.channel.kafka.KafkaChannelBinding;
import com.asyncapi.v2.binding.message.MessageBinding;
import com.asyncapi.v2.binding.message.kafka.KafkaMessageBinding;
import com.asyncapi.v2.binding.operation.OperationBinding;
import com.asyncapi.v2.binding.operation.kafka.KafkaOperationBinding;
import com.asyncapi.v2.schema.Schema;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.lang.Nullable;
import org.springframework.util.StringValueResolver;

public class KafkaListenerUtil {
    private static final Logger log = LoggerFactory.getLogger(KafkaListenerUtil.class);

    public static String getChannelName(KafkaListener annotation, StringValueResolver resolver) {
        List resolvedTopics = Arrays.stream(annotation.topics()).map(arg_0 -> ((StringValueResolver)resolver).resolveStringValue(arg_0)).collect(Collectors.toList());
        log.debug("Found topics: {}", (Object)String.join((CharSequence)", ", resolvedTopics));
        return (String)resolvedTopics.get(0);
    }

    public static Map<String, ? extends ChannelBinding> buildChannelBinding() {
        return Map.of("kafka", new KafkaChannelBinding());
    }

    public static Map<String, ? extends OperationBinding> buildOperationBinding(KafkaListener annotation, StringValueResolver resolver) {
        String groupId = resolver.resolveStringValue(annotation.groupId());
        Schema groupIdSchema = KafkaListenerUtil.buildKafkaGroupIdSchema(groupId);
        KafkaOperationBinding binding = new KafkaOperationBinding();
        binding.setGroupId((Object)groupIdSchema);
        return Map.of("kafka", binding);
    }

    @Nullable
    public static Schema buildKafkaClientIdSchema(String clientId) {
        Schema schema = KafkaListenerUtil.createStringSchema(clientId);
        if (schema != null) {
            log.debug("Found client id: {}", (Object)clientId);
        } else {
            log.debug("No client id found for this listener");
        }
        return schema;
    }

    @Nullable
    public static Schema buildKafkaGroupIdSchema(String groupId) {
        Schema schema = KafkaListenerUtil.createStringSchema(groupId);
        if (schema != null) {
            log.debug("Found group id: {}", (Object)groupId);
        } else {
            log.debug("No group id found for this listener");
        }
        return schema;
    }

    @Nullable
    private static Schema createStringSchema(String value) {
        if (value != null && !value.isEmpty()) {
            Schema schema = new Schema();
            schema.setEnumValue(List.of(value));
            schema.setType((Object)"string");
            return schema;
        }
        return null;
    }

    public static Map<String, ? extends MessageBinding> buildMessageBinding() {
        return Map.of("kafka", new KafkaMessageBinding());
    }
}

