/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.producer;

import io.github.stavshamir.springwolf.asyncapi.kafka.SpringwolfKafkaProducerConfiguration;
import io.github.stavshamir.springwolf.configuration.properties.SpringwolfKafkaConfigProperties;
import java.util.Map;
import java.util.Optional;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.ssl.DefaultSslBundleRegistry;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;

@ConditionalOnBean(value={SpringwolfKafkaProducerConfiguration.class})
public class SpringwolfKafkaTemplateFactory {
    private final SpringwolfKafkaConfigProperties springWolfKafkaConfigProperties;

    public Optional<KafkaTemplate<Object, Object>> buildKafkaTemplate() {
        Optional<KafkaTemplate<Object, Object>> kafkaTemplate = Optional.empty();
        if (this.springWolfKafkaConfigProperties.getPublishing() != null && this.springWolfKafkaConfigProperties.getPublishing().getProducer() != null) {
            Map producerProperties = this.springWolfKafkaConfigProperties.getPublishing().getProducer().buildProperties((SslBundles)new DefaultSslBundleRegistry());
            DefaultKafkaProducerFactory producerFactory = new DefaultKafkaProducerFactory(producerProperties);
            kafkaTemplate = Optional.of(new KafkaTemplate((ProducerFactory)producerFactory));
        }
        return kafkaTemplate;
    }

    public SpringwolfKafkaTemplateFactory(SpringwolfKafkaConfigProperties springWolfKafkaConfigProperties) {
        this.springWolfKafkaConfigProperties = springWolfKafkaConfigProperties;
    }
}

