/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.producer;

import com.asyncapi.v2.model.server.Server;
import com.google.common.collect.ImmutableMap;
import io.github.stavshamir.springwolf.configuration.AsyncApiDocket;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.support.serializer.JsonSerializer;
import org.springframework.stereotype.Service;

@Service
public class SpringwolfKafkaProducer {
    private static final Logger log = LoggerFactory.getLogger(SpringwolfKafkaProducer.class);
    private final KafkaTemplate<String, Map<String, Object>> kafkaTemplate;
    private boolean isEnabled = true;

    public SpringwolfKafkaProducer(@Autowired AsyncApiDocket docket) {
        Optional<String> bootstrapServers = this.getBootstrapServers(docket);
        if (bootstrapServers.isPresent()) {
            Map<String, Object> config = this.buildProducerConfiguration(bootstrapServers.get());
            DefaultKafkaProducerFactory factory = new DefaultKafkaProducerFactory(config);
            this.kafkaTemplate = new KafkaTemplate((ProducerFactory)factory);
        } else {
            log.warn("No Kafka server found in the docket - at least one server must be configured with protocol 'kafka'");
            this.kafkaTemplate = null;
            this.isEnabled = false;
        }
    }

    public void send(String topic, Map<String, Object> payload) {
        if (!this.isEnabled) {
            log.debug("Kafka producer is disabled");
            return;
        }
        if (this.kafkaTemplate == null) {
            log.warn("Kafka producer is not configured");
            return;
        }
        this.kafkaTemplate.send(topic, payload);
    }

    private Optional<String> getBootstrapServers(AsyncApiDocket docket) {
        return docket.getServers().values().stream().filter(server -> server.getProtocol().equals("kafka")).map(Server::getUrl).findFirst();
    }

    private Map<String, Object> buildProducerConfiguration(String bootstrapServers) {
        return ImmutableMap.of((Object)"bootstrap.servers", (Object)bootstrapServers, (Object)"key.serializer", StringSerializer.class, (Object)"value.serializer", JsonSerializer.class, (Object)"spring.json.add.type.headers", (Object)false);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }
}

