/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi.scanners.channels;

import com.asyncapi.v2.binding.OperationBinding;
import com.asyncapi.v2.binding.kafka.KafkaOperationBinding;
import com.asyncapi.v2.model.channel.ChannelItem;
import com.asyncapi.v2.model.channel.operation.Operation;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.ChannelsScanner;
import io.github.stavshamir.springwolf.asyncapi.scanners.components.ComponentsScanner;
import io.github.stavshamir.springwolf.asyncapi.types.channel.operation.message.Message;
import io.github.stavshamir.springwolf.asyncapi.types.channel.operation.message.PayloadReference;
import io.github.stavshamir.springwolf.configuration.AsyncApiDocket;
import io.github.stavshamir.springwolf.schemas.SchemasService;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.kafka.annotation.KafkaHandler;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Service;
import org.springframework.util.StringValueResolver;

@Service
public class ClassLevelKafkaListenerScanner
implements ChannelsScanner,
EmbeddedValueResolverAware {
    private static final Logger log = LoggerFactory.getLogger(ClassLevelKafkaListenerScanner.class);
    private StringValueResolver resolver;
    @Autowired
    private AsyncApiDocket docket;
    @Autowired
    private ComponentsScanner componentsScanner;
    @Autowired
    private SchemasService schemasService;

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.resolver = resolver;
    }

    public Map<String, ChannelItem> scan() {
        return this.componentsScanner.scanForComponents(this.docket.getBasePackage()).stream().filter(this::isAnnotatedWithKafkaListener).map(this::mapClassToChannel).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private boolean isAnnotatedWithKafkaListener(Class<?> component) {
        return component.isAnnotationPresent(KafkaListener.class);
    }

    private Optional<Map.Entry<String, ChannelItem>> mapClassToChannel(Class<?> component) {
        log.debug("Mapping class \"{}\" to channel", (Object)component.getName());
        KafkaListener annotation = component.getAnnotation(KafkaListener.class);
        String channelName = this.getChannelName(annotation);
        Map<String, ? extends OperationBinding> operationBinding = this.buildOperationBinding(annotation);
        Set<Method> annotatedMethods = this.getAnnotatedMethods(component);
        if (annotatedMethods.isEmpty()) {
            return Optional.empty();
        }
        ChannelItem channelItem = this.buildChannel(annotatedMethods, operationBinding);
        return Optional.of(Maps.immutableEntry((Object)channelName, (Object)channelItem));
    }

    protected String getChannelName(KafkaListener annotation) {
        List resolvedTopics = Arrays.stream(annotation.topics()).map(arg_0 -> ((StringValueResolver)this.resolver).resolveStringValue(arg_0)).collect(Collectors.toList());
        log.debug("Found topics: {}", (Object)String.join((CharSequence)", ", resolvedTopics));
        return (String)resolvedTopics.get(0);
    }

    protected Map<String, ? extends OperationBinding> buildOperationBinding(KafkaListener annotation) {
        String groupId = this.resolver.resolveStringValue(annotation.groupId());
        if (groupId == null || groupId.isEmpty()) {
            log.debug("No group ID found for this listener");
            groupId = null;
        } else {
            log.debug("Found group id: {}", (Object)groupId);
        }
        KafkaOperationBinding binding = new KafkaOperationBinding();
        binding.setGroupId((Object)groupId);
        return ImmutableMap.of((Object)"kafka", (Object)binding);
    }

    protected Class<?> getPayloadType(Method method) {
        String methodName = String.format("%s::%s", method.getDeclaringClass().getSimpleName(), method.getName());
        log.debug("Finding payload type for {}", (Object)methodName);
        Class<?>[] parameterTypes = method.getParameterTypes();
        switch (parameterTypes.length) {
            case 0: {
                throw new IllegalArgumentException("Listener methods must not have 0 parameters: " + methodName);
            }
            case 1: {
                return parameterTypes[0];
            }
        }
        return this.getPayloadType(parameterTypes, method.getParameterAnnotations(), methodName);
    }

    private Class<?> getPayloadType(Class<?>[] parameterTypes, Annotation[][] parameterAnnotations, String methodName) {
        int payloadAnnotatedParameterIndex = this.getPayloadAnnotatedParameterIndex(parameterAnnotations);
        if (payloadAnnotatedParameterIndex == -1) {
            String msg = "Multi-parameter methods must have one parameter annotated with @Payload, but none was found: " + methodName;
            throw new IllegalArgumentException(msg);
        }
        return parameterTypes[payloadAnnotatedParameterIndex];
    }

    private int getPayloadAnnotatedParameterIndex(Annotation[][] parameterAnnotations) {
        int length = parameterAnnotations.length;
        for (int i = 0; i < length; ++i) {
            Annotation[] annotations = parameterAnnotations[i];
            boolean hasPayloadAnnotation = Arrays.stream(annotations).anyMatch(annotation -> annotation instanceof Payload);
            if (!hasPayloadAnnotation) continue;
            return i;
        }
        return -1;
    }

    private Set<Method> getAnnotatedMethods(Class<?> component) {
        Class<KafkaHandler> annotationClass = KafkaHandler.class;
        log.debug("Scanning class \"{}\" for @\"{}\" annotated methods", (Object)component.getName(), (Object)annotationClass.getName());
        return Arrays.stream(component.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(annotationClass)).collect(Collectors.toSet());
    }

    private ChannelItem buildChannel(Set<Method> methods, Map<String, ? extends OperationBinding> operationBinding) {
        Operation operation = Operation.builder().message(this.getMessageObject(methods)).bindings(operationBinding).build();
        return ChannelItem.builder().publish(operation).build();
    }

    private Object getMessageObject(Set<Method> methods) {
        Set messages = methods.stream().map(this::buildMessage).collect(Collectors.toSet());
        return methods.size() == 1 ? messages.toArray()[0] : ImmutableMap.of((Object)"oneOf", messages);
    }

    private Message buildMessage(Method method) {
        Class<?> payloadType = this.getPayloadType(method);
        String modelName = this.schemasService.register(payloadType);
        return Message.builder().name(payloadType.getName()).title(modelName).payload(PayloadReference.fromModelName((String)modelName)).build();
    }
}

