/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi;

import io.github.stavshamir.springwolf.producer.SpringwolfKafkaProducer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/springwolf/kafka"})
public class SpringwolfKafkaController {
    private static final Logger log = LoggerFactory.getLogger(SpringwolfKafkaController.class);
    private final SpringwolfKafkaProducer kafkaProducer;

    @PostMapping(value={"/publish"})
    public void publish(@RequestParam String topic, @RequestBody Map<String, Object> payload) {
        if (!this.kafkaProducer.isEnabled()) {
            log.debug("Kafka producer is not enabled - message will not be published");
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Kafka producer is not enabled");
        }
        log.info("Publishing to kafka topic {}: {}", (Object)topic, payload);
        this.kafkaProducer.send(topic, payload);
    }

    public SpringwolfKafkaController(SpringwolfKafkaProducer kafkaProducer) {
        this.kafkaProducer = kafkaProducer;
    }
}

