/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi.scanners.channels;

import com.asyncapi.v2.binding.ChannelBinding;
import com.asyncapi.v2.binding.OperationBinding;
import com.asyncapi.v2.binding.kafka.KafkaChannelBinding;
import com.asyncapi.v2.binding.kafka.KafkaOperationBinding;
import com.google.common.collect.ImmutableMap;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.AbstractChannelScanner;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.ChannelsScanner;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Service;
import org.springframework.util.StringValueResolver;

@Service
public class MethodLevelKafkaListenerScanner
extends AbstractChannelScanner<KafkaListener>
implements ChannelsScanner,
EmbeddedValueResolverAware {
    private static final Logger log = LoggerFactory.getLogger(MethodLevelKafkaListenerScanner.class);
    private StringValueResolver resolver;

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.resolver = resolver;
    }

    protected Class<KafkaListener> getListenerAnnotationClass() {
        return KafkaListener.class;
    }

    protected String getChannelName(KafkaListener annotation) {
        List resolvedTopics = Arrays.stream(annotation.topics()).map(arg_0 -> ((StringValueResolver)this.resolver).resolveStringValue(arg_0)).collect(Collectors.toList());
        log.debug("Found topics: {}", (Object)String.join((CharSequence)", ", resolvedTopics));
        return (String)resolvedTopics.get(0);
    }

    protected Map<String, ? extends ChannelBinding> buildChannelBinding(KafkaListener annotation) {
        return ImmutableMap.of((Object)"kafka", (Object)new KafkaChannelBinding());
    }

    protected Map<String, ? extends OperationBinding> buildOperationBinding(KafkaListener annotation) {
        String groupId = this.resolver.resolveStringValue(annotation.groupId());
        if (groupId == null || groupId.isEmpty()) {
            log.debug("No group ID found for this listener");
            groupId = null;
        } else {
            log.debug("Found group id: {}", (Object)groupId);
        }
        KafkaOperationBinding binding = new KafkaOperationBinding();
        binding.setGroupId((Object)groupId);
        return ImmutableMap.of((Object)"kafka", (Object)binding);
    }

    protected Class<?> getPayloadType(Method method) {
        String methodName = String.format("%s::%s", method.getDeclaringClass().getSimpleName(), method.getName());
        log.debug("Finding payload type for {}", (Object)methodName);
        Class<?>[] parameterTypes = method.getParameterTypes();
        switch (parameterTypes.length) {
            case 0: {
                throw new IllegalArgumentException("Listener methods must not have 0 parameters: " + methodName);
            }
            case 1: {
                return parameterTypes[0];
            }
        }
        return this.getPayloadType(parameterTypes, method.getParameterAnnotations(), methodName);
    }

    private Class<?> getPayloadType(Class<?>[] parameterTypes, Annotation[][] parameterAnnotations, String methodName) {
        int payloadAnnotatedParameterIndex = this.getPayloadAnnotatedParameterIndex(parameterAnnotations);
        if (payloadAnnotatedParameterIndex == -1) {
            String msg = "Multi-parameter KafkaListener methods must have one parameter annotated with @Payload, but none was found: " + methodName;
            throw new IllegalArgumentException(msg);
        }
        return parameterTypes[payloadAnnotatedParameterIndex];
    }

    private int getPayloadAnnotatedParameterIndex(Annotation[][] parameterAnnotations) {
        int length = parameterAnnotations.length;
        for (int i = 0; i < length; ++i) {
            Annotation[] annotations = parameterAnnotations[i];
            boolean hasPayloadAnnotation = Arrays.stream(annotations).anyMatch(annotation -> annotation instanceof Payload);
            if (!hasPayloadAnnotation) continue;
            return i;
        }
        return -1;
    }
}

