/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi.types;

import com.asyncapi.v2.binding.kafka.KafkaChannelBinding;
import com.asyncapi.v2.binding.kafka.KafkaOperationBinding;
import com.google.common.collect.ImmutableMap;
import io.github.stavshamir.springwolf.asyncapi.types.ConsumerData;

public class KafkaConsumerData
extends ConsumerData {
    public KafkaConsumerData(String topicName, Class<?> payloadType, String description) {
        this.channelName = topicName;
        this.description = description;
        this.channelBinding = ImmutableMap.of((Object)"kafka", (Object)new KafkaChannelBinding());
        this.payloadType = payloadType;
        this.operationBinding = ImmutableMap.of((Object)"kafka", (Object)new KafkaOperationBinding());
    }

    public static KafkaConsumerDataBuilder kafkaConsumerDataBuilder() {
        return new KafkaConsumerDataBuilder();
    }

    public static class KafkaConsumerDataBuilder {
        private String topicName;
        private Class<?> payloadType;
        private String description;

        KafkaConsumerDataBuilder() {
        }

        public KafkaConsumerDataBuilder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public KafkaConsumerDataBuilder payloadType(Class<?> payloadType) {
            this.payloadType = payloadType;
            return this;
        }

        public KafkaConsumerDataBuilder description(String description) {
            this.description = description;
            return this;
        }

        public KafkaConsumerData build() {
            return new KafkaConsumerData(this.topicName, this.payloadType, this.description);
        }

        public String toString() {
            return "KafkaConsumerData.KafkaConsumerDataBuilder(topicName=" + this.topicName + ", payloadType=" + this.payloadType + ", description=" + this.description + ")";
        }
    }
}

