/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi.types;

import com.asyncapi.v2.binding.kafka.KafkaChannelBinding;
import com.asyncapi.v2.binding.kafka.KafkaOperationBinding;
import com.google.common.collect.ImmutableMap;
import io.github.stavshamir.springwolf.asyncapi.types.ProducerData;

public class KafkaProducerData
extends ProducerData {
    public KafkaProducerData(String topicName, Class<?> payloadType, String description) {
        this.channelName = topicName;
        this.description = description;
        this.channelBinding = ImmutableMap.of((Object)"kafka", (Object)new KafkaChannelBinding());
        this.payloadType = payloadType;
        this.operationBinding = ImmutableMap.of((Object)"kafka", (Object)new KafkaOperationBinding());
    }

    public static KafkaProducerDataBuilder kafkaProducerDataBuilder() {
        return new KafkaProducerDataBuilder();
    }

    public static class KafkaProducerDataBuilder {
        private String topicName;
        private Class<?> payloadType;
        private String description;

        KafkaProducerDataBuilder() {
        }

        public KafkaProducerDataBuilder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public KafkaProducerDataBuilder payloadType(Class<?> payloadType) {
            this.payloadType = payloadType;
            return this;
        }

        public KafkaProducerDataBuilder description(String description) {
            this.description = description;
            return this;
        }

        public KafkaProducerData build() {
            return new KafkaProducerData(this.topicName, this.payloadType, this.description);
        }

        public String toString() {
            return "KafkaProducerData.KafkaProducerDataBuilder(topicName=" + this.topicName + ", payloadType=" + this.payloadType + ", description=" + this.description + ")";
        }
    }
}

