/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.plugins.kafka.asyncapi.components.header;

import io.github.springwolf.asyncapi.v3.model.schema.SchemaObject;
import java.util.HashMap;
import java.util.List;

public class AsyncHeadersForSpringKafkaBuilder {
    private final SchemaObject headers;

    public AsyncHeadersForSpringKafkaBuilder() {
        this("SpringKafkaDefaultHeaders");
    }

    public AsyncHeadersForSpringKafkaBuilder(String schemaName) {
        this.headers = SchemaObject.builder().type("object").title(schemaName).properties(new HashMap()).build();
    }

    public AsyncHeadersForSpringKafkaBuilder withTypeIdHeader(String exampleTypeId) {
        return this.withTypeIdHeader(exampleTypeId, List.of(exampleTypeId));
    }

    public AsyncHeadersForSpringKafkaBuilder withTypeIdHeader(String exampleTypeId, List<String> types) {
        return this.withHeader("__TypeId__", types, exampleTypeId, "Spring Type Id Header");
    }

    private AsyncHeadersForSpringKafkaBuilder withHeader(String headerName, List<String> types, String exampleType, String description) {
        SchemaObject header = new SchemaObject();
        header.setType("string");
        header.setTitle(headerName);
        header.setDescription(description);
        header.setExamples(List.of(exampleType));
        header.setEnumValues(types);
        this.headers.getProperties().put(headerName, header);
        return this;
    }

    public SchemaObject build() {
        return this.headers;
    }
}

