/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.plugins.kafka.asyncapi.scanners.common;

import io.github.springwolf.asyncapi.v3.bindings.ChannelBinding;
import io.github.springwolf.asyncapi.v3.bindings.MessageBinding;
import io.github.springwolf.asyncapi.v3.bindings.OperationBinding;
import io.github.springwolf.asyncapi.v3.bindings.kafka.KafkaChannelBinding;
import io.github.springwolf.asyncapi.v3.bindings.kafka.KafkaMessageBinding;
import io.github.springwolf.asyncapi.v3.bindings.kafka.KafkaOperationBinding;
import io.github.springwolf.asyncapi.v3.model.schema.Schema;
import io.github.springwolf.asyncapi.v3.model.schema.SchemaObject;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.util.StringValueResolver;

public class KafkaListenerUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaListenerUtil.class);

    public static String getChannelName(KafkaListener annotation, StringValueResolver stringValueResolver) {
        Stream<String> topicName = Stream.concat(Arrays.stream(annotation.topics()), Stream.of(annotation.topicPattern()));
        List resolvedTopics = topicName.map(arg_0 -> ((StringValueResolver)stringValueResolver).resolveStringValue(arg_0)).collect(Collectors.toList());
        log.debug("Found topics: {}", (Object)String.join((CharSequence)", ", resolvedTopics));
        return (String)resolvedTopics.get(0);
    }

    public static Map<String, ChannelBinding> buildChannelBinding() {
        return Map.of("kafka", new KafkaChannelBinding());
    }

    public static Map<String, OperationBinding> buildOperationBinding(KafkaListener annotation, StringValueResolver stringValueResolver) {
        String groupId = stringValueResolver.resolveStringValue(annotation.groupId());
        SchemaObject groupIdSchema = KafkaListenerUtil.buildKafkaGroupIdSchema(groupId);
        KafkaOperationBinding binding = new KafkaOperationBinding();
        binding.setGroupId((Schema)groupIdSchema);
        return Map.of("kafka", binding);
    }

    @Nullable
    public static SchemaObject buildKafkaClientIdSchema(String clientId) {
        SchemaObject schema = KafkaListenerUtil.createStringSchema(clientId);
        if (schema != null) {
            log.debug("Found client id: {}", (Object)clientId);
        } else {
            log.debug("No client id found for this listener");
        }
        return schema;
    }

    @Nullable
    public static SchemaObject buildKafkaGroupIdSchema(String groupId) {
        SchemaObject schema = KafkaListenerUtil.createStringSchema(groupId);
        if (schema != null) {
            log.debug("Found group id: {}", (Object)groupId);
        } else {
            log.debug("No group id found for this listener");
        }
        return schema;
    }

    @Nullable
    private static SchemaObject createStringSchema(String value) {
        if (value != null && !value.isEmpty()) {
            SchemaObject schema = new SchemaObject();
            schema.setEnumValues(List.of(value));
            schema.setType("string");
            return schema;
        }
        return null;
    }

    public static Map<String, MessageBinding> buildMessageBinding(SchemaObject headerSchema) {
        KafkaMessageBinding kafkaMessageBinding = new KafkaMessageBinding();
        Map properties = headerSchema.getProperties();
        if (properties != null && properties.containsKey("kafka_receivedMessageKey")) {
            kafkaMessageBinding.setKey((Schema)((SchemaObject)properties.get("kafka_receivedMessageKey")));
        }
        return Map.of("kafka", kafkaMessageBinding);
    }
}

