/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.plugins.kafka.producer;

import io.github.springwolf.plugins.kafka.producer.SpringwolfKafkaTemplateProvider;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;

public class SpringwolfKafkaProducer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringwolfKafkaProducer.class);
    private final SpringwolfKafkaTemplateProvider kafkaTemplateProvider;

    public boolean isEnabled() {
        return this.kafkaTemplateProvider.isPresent();
    }

    public void send(String topic, String key, Map<String, String> headers, Object payload) {
        Optional<KafkaTemplate<Object, Object>> kafkaTemplate = this.kafkaTemplateProvider.get(topic);
        if (kafkaTemplate.isPresent()) {
            kafkaTemplate.get().send(this.buildProducerRecord(topic, key, headers, payload)).toCompletableFuture().join();
        } else {
            log.warn("Kafka producer for topic {} is not configured", (Object)topic);
        }
    }

    private ProducerRecord<Object, Object> buildProducerRecord(String topic, String key, Map<String, String> headers, Object payload) {
        List recordHeaders = headers != null ? this.buildHeaders(headers) : Collections.emptyList();
        return new ProducerRecord(topic, null, null, (Object)key, payload, recordHeaders);
    }

    private List<Header> buildHeaders(Map<String, String> headers) {
        return headers.entrySet().stream().map(header -> new RecordHeader((String)header.getKey(), ((String)header.getValue()).getBytes(StandardCharsets.UTF_8))).collect(Collectors.toList());
    }

    @Generated
    public SpringwolfKafkaProducer(SpringwolfKafkaTemplateProvider kafkaTemplateProvider) {
        this.kafkaTemplateProvider = kafkaTemplateProvider;
    }
}

