/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.plugins.stomp.asyncapi.scanners.operation.annotations;

import io.github.springwolf.asyncapi.v3.model.channel.ChannelReference;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageReference;
import io.github.springwolf.asyncapi.v3.model.operation.Operation;
import io.github.springwolf.asyncapi.v3.model.operation.OperationReply;
import io.github.springwolf.core.asyncapi.scanners.common.annotation.AnnotationUtil;
import io.github.springwolf.core.asyncapi.scanners.common.payload.PayloadMethodReturnService;
import io.github.springwolf.core.asyncapi.scanners.operations.annotations.OperationCustomizer;
import io.github.springwolf.plugins.stomp.asyncapi.scanners.bindings.StompBindingSendToFactory;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import lombok.Generated;
import org.springframework.messaging.handler.annotation.SendTo;

public class SendToCustomizer
implements OperationCustomizer {
    private final StompBindingSendToFactory bindingFactory;
    private final PayloadMethodReturnService payloadService;

    public void customize(Operation operation, Method method) {
        SendTo annotation = (SendTo)AnnotationUtil.findFirstAnnotation(SendTo.class, (AnnotatedElement)method);
        if (annotation != null) {
            String channelId = this.bindingFactory.getChannelId(annotation);
            String payloadName = this.payloadService.extractSchema(method).name();
            operation.setReply(OperationReply.builder().channel(ChannelReference.fromChannel((String)channelId)).messages(List.of(MessageReference.toChannelMessage((String)channelId, (String)payloadName))).build());
        }
    }

    @Generated
    public SendToCustomizer(StompBindingSendToFactory bindingFactory, PayloadMethodReturnService payloadService) {
        this.bindingFactory = bindingFactory;
        this.payloadService = payloadService;
    }
}

