/*
 * Decompiled with CFR 0.152.
 */
package io.github.sskorol.cdt.protocol.commands;

import io.github.sskorol.cdt.protocol.events.storage.CacheStorageContentUpdated;
import io.github.sskorol.cdt.protocol.events.storage.CacheStorageListUpdated;
import io.github.sskorol.cdt.protocol.events.storage.IndexedDBContentUpdated;
import io.github.sskorol.cdt.protocol.events.storage.IndexedDBListUpdated;
import io.github.sskorol.cdt.protocol.events.storage.InterestGroupAccessed;
import io.github.sskorol.cdt.protocol.support.annotations.EventName;
import io.github.sskorol.cdt.protocol.support.annotations.Experimental;
import io.github.sskorol.cdt.protocol.support.annotations.Optional;
import io.github.sskorol.cdt.protocol.support.annotations.ParamName;
import io.github.sskorol.cdt.protocol.support.annotations.ReturnTypeParameter;
import io.github.sskorol.cdt.protocol.support.annotations.Returns;
import io.github.sskorol.cdt.protocol.support.types.EventHandler;
import io.github.sskorol.cdt.protocol.support.types.EventListener;
import io.github.sskorol.cdt.protocol.types.network.Cookie;
import io.github.sskorol.cdt.protocol.types.network.CookieParam;
import io.github.sskorol.cdt.protocol.types.storage.InterestGroupDetails;
import io.github.sskorol.cdt.protocol.types.storage.TrustTokens;
import io.github.sskorol.cdt.protocol.types.storage.UsageAndQuota;
import java.util.List;

@Experimental
public interface Storage {
    public void clearDataForOrigin(@ParamName(value="origin") String var1, @ParamName(value="storageTypes") String var2);

    @Returns(value="cookies")
    @ReturnTypeParameter(value={Cookie.class})
    public List<Cookie> getCookies();

    @Returns(value="cookies")
    @ReturnTypeParameter(value={Cookie.class})
    public List<Cookie> getCookies(@Optional @ParamName(value="browserContextId") String var1);

    public void setCookies(@ParamName(value="cookies") List<CookieParam> var1);

    public void setCookies(@ParamName(value="cookies") List<CookieParam> var1, @Optional @ParamName(value="browserContextId") String var2);

    public void clearCookies();

    public void clearCookies(@Optional @ParamName(value="browserContextId") String var1);

    public UsageAndQuota getUsageAndQuota(@ParamName(value="origin") String var1);

    @Experimental
    public void overrideQuotaForOrigin(@ParamName(value="origin") String var1);

    @Experimental
    public void overrideQuotaForOrigin(@ParamName(value="origin") String var1, @Optional @ParamName(value="quotaSize") Double var2);

    public void trackCacheStorageForOrigin(@ParamName(value="origin") String var1);

    public void trackIndexedDBForOrigin(@ParamName(value="origin") String var1);

    public void untrackCacheStorageForOrigin(@ParamName(value="origin") String var1);

    public void untrackIndexedDBForOrigin(@ParamName(value="origin") String var1);

    @Experimental
    @Returns(value="tokens")
    @ReturnTypeParameter(value={TrustTokens.class})
    public List<TrustTokens> getTrustTokens();

    @Experimental
    @Returns(value="didDeleteTokens")
    public Boolean clearTrustTokens(@ParamName(value="issuerOrigin") String var1);

    @Experimental
    @Returns(value="details")
    public InterestGroupDetails getInterestGroupDetails(@ParamName(value="ownerOrigin") String var1, @ParamName(value="name") String var2);

    @Experimental
    public void setInterestGroupTracking(@ParamName(value="enable") Boolean var1);

    @EventName(value="cacheStorageContentUpdated")
    public EventListener onCacheStorageContentUpdated(EventHandler<CacheStorageContentUpdated> var1);

    @EventName(value="cacheStorageListUpdated")
    public EventListener onCacheStorageListUpdated(EventHandler<CacheStorageListUpdated> var1);

    @EventName(value="indexedDBContentUpdated")
    public EventListener onIndexedDBContentUpdated(EventHandler<IndexedDBContentUpdated> var1);

    @EventName(value="indexedDBListUpdated")
    public EventListener onIndexedDBListUpdated(EventHandler<IndexedDBListUpdated> var1);

    @EventName(value="interestGroupAccessed")
    public EventListener onInterestGroupAccessed(EventHandler<InterestGroupAccessed> var1);
}

