/*
 * Decompiled with CFR 0.152.
 */
package io.github.sskorol.cdt.services;

import io.github.sskorol.cdt.protocol.ChromeDevTools;
import io.github.sskorol.cdt.protocol.support.types.EventHandler;
import io.github.sskorol.cdt.protocol.support.types.EventListener;
import io.github.sskorol.cdt.services.WebSocketService;
import io.github.sskorol.cdt.services.config.ChromeDevToolsServiceConfiguration;
import io.github.sskorol.cdt.services.exceptions.WebSocketServiceException;
import io.github.sskorol.cdt.services.impl.ChromeDevToolsServiceImpl;
import io.github.sskorol.cdt.services.impl.WebSocketServiceImpl;
import io.github.sskorol.cdt.services.invocation.CommandInvocationHandler;
import io.github.sskorol.cdt.services.types.MethodInvocation;
import io.github.sskorol.cdt.services.utils.ProxyUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ConcurrentHashMap;

public interface ChromeDevToolsService
extends ChromeDevTools,
AutoCloseable {
    @Deprecated
    public <T> T invoke(String var1, Class<T> var2, MethodInvocation var3);

    public <T> T invoke(String var1, Class<T> var2, Class<?>[] var3, MethodInvocation var4);

    @Override
    public void close();

    public boolean isClosed();

    public void waitUntilClosed();

    public EventListener addEventListener(String var1, String var2, EventHandler var3, Class<?> var4);

    public void removeEventListener(EventListener var1);

    public static ChromeDevToolsService from(String webSocketURI) throws URISyntaxException, WebSocketServiceException {
        return ChromeDevToolsService.from(WebSocketServiceImpl.create(new URI(webSocketURI)));
    }

    public static ChromeDevToolsService from(WebSocketService webSocketService) {
        CommandInvocationHandler invocationHandler = new CommandInvocationHandler();
        ConcurrentHashMap commandsCache = new ConcurrentHashMap();
        ChromeDevToolsService devtools = ProxyUtils.createProxyFromAbstract(ChromeDevToolsServiceImpl.class, new Class[]{WebSocketService.class, ChromeDevToolsServiceConfiguration.class}, new Object[]{webSocketService, new ChromeDevToolsServiceConfiguration()}, (unused, method, args) -> commandsCache.computeIfAbsent(method, key -> ProxyUtils.createProxy(method.getReturnType(), invocationHandler)));
        invocationHandler.setChromeDevToolsService(devtools);
        return devtools;
    }
}

