/*
 * Decompiled with CFR 0.152.
 */
package io.github.sskorol.cdt.services.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationUtils.class);

    private ConfigurationUtils() {
    }

    public static long systemProperty(String name, long defaultValue) {
        String propertyValue = System.getProperty(name);
        if (propertyValue != null) {
            try {
                return Long.parseLong(propertyValue.trim());
            }
            catch (NumberFormatException ex) {
                LOGGER.error("Failed parsing {} value.", (Object)name, (Object)ex);
            }
        }
        return defaultValue;
    }

    public static String systemProperty(String name, String defaultValue) {
        String propertyValue = System.getProperty(name);
        if (propertyValue != null && !propertyValue.trim().isEmpty()) {
            return propertyValue.trim();
        }
        return defaultValue;
    }
}

