/*
 * Decompiled with CFR 0.152.
 */
package io.github.sskorol.core;

import io.github.sskorol.core.DataSupplier;
import io.github.sskorol.model.DataSupplierMetaData;
import io.github.sskorol.utils.ReflectionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Objects;
import org.testng.IAnnotationTransformer;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.IFactoryAnnotation;
import org.testng.annotations.ITestAnnotation;
import org.testng.internal.annotations.IDataProvidable;

public class DataProviderTransformer
implements IAnnotationTransformer {
    @DataProvider
    public Iterator<Object[]> supplySeqData(ITestContext context, ITestNGMethod testMethod) {
        return this.getMetaData(context, testMethod).getTestData().iterator();
    }

    @DataProvider(parallel=true)
    public Iterator<Object[]> supplyParallelData(ITestContext context, ITestNGMethod testMethod) {
        return this.getMetaData(context, testMethod).getTestData().iterator();
    }

    @DataProvider(propagateFailureAsTestFailure=true)
    public Iterator<Object[]> supplySeqDataWithErrorPropagation(ITestContext context, ITestNGMethod testMethod) {
        return this.getMetaData(context, testMethod).getTestData().iterator();
    }

    @DataProvider(parallel=true, propagateFailureAsTestFailure=true)
    public Iterator<Object[]> supplyParallelDataWithErrorPropagation(ITestContext context, ITestNGMethod testMethod) {
        return this.getMetaData(context, testMethod).getTestData().iterator();
    }

    public void transform(ITestAnnotation annotation, Class testClass, Constructor testConstructor, Method testMethod) {
        this.assignCustomDataSupplier((IDataProvidable)annotation, testMethod, testClass);
    }

    public void transform(IFactoryAnnotation annotation, Method testMethod) {
        this.assignCustomDataSupplier((IDataProvidable)annotation, testMethod, null);
    }

    private DataSupplierMetaData getMetaData(ITestContext context, ITestNGMethod testMethod) {
        return new DataSupplierMetaData(context, testMethod);
    }

    private <T> void assignCustomDataSupplier(IDataProvidable annotation, Method testMethod, Class<T> testClass) {
        Class dataSupplierClass = ReflectionUtils.getDataSupplierClass(annotation, testClass, testMethod);
        DataSupplier dataSupplierAnnotation = ReflectionUtils.getDataSupplierAnnotation(dataSupplierClass, annotation.getDataProvider());
        if (!annotation.getDataProvider().isEmpty() && Objects.nonNull(dataSupplierAnnotation)) {
            annotation.setDataProviderClass(this.getClass());
            String propagationSuffix = dataSupplierAnnotation.propagateTestFailure() ? "WithErrorPropagation" : "";
            String dataProviderName = (dataSupplierAnnotation.runInParallel() ? "supplyParallelData" : "supplySeqData") + propagationSuffix;
            annotation.setDataProvider(dataProviderName);
        }
    }
}

