/*
 * Decompiled with CFR 0.152.
 */
package io.github.sskorol.data;

import io.github.sskorol.data.DataReader;
import io.github.sskorol.utils.ReflectionUtils;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.joor.Reflect;

public class CsvReader<T>
implements DataReader<T> {
    private final Class<T> entityClass;
    private final String path;

    public CsvReader(Class<T> entityClass) {
        this(entityClass, "");
    }

    @Override
    public StreamEx<T> read() {
        StreamEx streamEx;
        block8: {
            CSVParser csvParser = CSVParser.parse((URL)this.getUrl(), (Charset)StandardCharsets.UTF_8, (CSVFormat)CSVFormat.Builder.create().setHeader(new String[0]).setSkipHeaderRecord(true).setIgnoreHeaderCase(true).setTrim(true).build());
            try {
                List entityFields = StreamEx.of((Object[])this.entityClass.getDeclaredFields()).map(ReflectionUtils::getFieldName).toList();
                streamEx = StreamEx.of((Collection)csvParser.getRecords()).map(csvRecord -> StreamEx.of((Collection)entityFields).map(arg_0 -> ((CSVRecord)csvRecord).get(arg_0)).toArray()).map(args -> Reflect.onClass(this.entityClass).create(args).get());
                if (csvParser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (csvParser != null) {
                        try {
                            csvParser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException(String.format("Unable to read CSV data to %s. Check provided path.", this.entityClass), ex);
                }
            }
            csvParser.close();
        }
        return streamEx;
    }

    public CsvReader(Class<T> entityClass, String path) {
        this.entityClass = entityClass;
        this.path = path;
    }

    @Override
    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public String getPath() {
        return this.path;
    }
}

