/*
 * Decompiled with CFR 0.152.
 */
package io.github.sskorol.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import io.github.sskorol.data.DataReader;
import io.github.sskorol.utils.ReflectionUtils;
import io.vavr.API;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import one.util.streamex.StreamEx;

public class JsonReader<T>
implements DataReader<T> {
    private final Class<T> entityClass;
    private final String path;

    public JsonReader(Class<T> entityClass) {
        this(entityClass, "");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public StreamEx<T> read() {
        Gson gson = new Gson();
        try (InputStreamReader streamReader = new InputStreamReader(this.getUrl().openStream(), StandardCharsets.UTF_8);){
            StreamEx streamEx;
            try (com.google.gson.stream.JsonReader jsonReader = new com.google.gson.stream.JsonReader((Reader)streamReader);){
                streamEx = (StreamEx)API.Match((Object)JsonParser.parseReader((com.google.gson.stream.JsonReader)jsonReader)).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$(JsonElement::isJsonArray), j -> StreamEx.of((Object[])((Object[])gson.fromJson(j, ReflectionUtils.castToArray(this.entityClass))))), API.Case((API.Match.Pattern0)API.$(), j -> StreamEx.of((Object)gson.fromJson(j, ReflectionUtils.castToObject(this.entityClass))))});
            }
            return streamEx;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(String.format("Unable to read JSON data to %s. Check provided path.", this.entityClass), ex);
        }
    }

    public JsonReader(Class<T> entityClass, String path) {
        this.entityClass = entityClass;
        this.path = path;
    }

    @Override
    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public String getPath() {
        return this.path;
    }
}

