/*
 * Decompiled with CFR 0.152.
 */
package io.github.sskorol.data;

import io.github.sskorol.converters.IConverter;
import io.github.sskorol.data.Column;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import one.util.streamex.StreamEx;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.joor.Reflect;

public class XlsxCellMapper<T> {
    private final int index;
    private final Field field;
    private final IConverter<T> converter;
    private final DataFormatter formatter;
    private final List<IConverter<T>> defaultIConverters;
    private T convertedValue;

    public XlsxCellMapper(Field field, Map<String, Integer> headers, List<IConverter<T>> defaultIConverters) {
        this.field = field;
        this.defaultIConverters = defaultIConverters;
        this.index = this.getColumn().map(Column::name).filter(headers::containsKey).map(headers::get).orElseThrow(() -> new IllegalArgumentException(String.format("Column %s not found", field.getName())));
        this.converter = this.findMatchingConverter();
        this.formatter = new DataFormatter();
    }

    public XlsxCellMapper<T> parse(Row row) {
        String cellValue = Optional.ofNullable(row.getCell(this.index, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL)).map(cell -> this.formatter.formatCellValue(cell).trim()).orElse("");
        this.convertedValue = this.converter.convert(cellValue, this.getColumn().map(Column::format).orElse(""));
        return this;
    }

    public <R> void assignValue(R instance) {
        Optional.ofNullable(this.convertedValue).ifPresent(value -> Reflect.on((Object)instance).set(this.getFieldName(), value));
    }

    private String getFieldName() {
        return this.field.getName();
    }

    private Type getFieldType() {
        return this.field.getType();
    }

    private Optional<Column> getColumn() {
        return Optional.ofNullable(this.field.getDeclaredAnnotation(Column.class));
    }

    private IConverter<T> findMatchingConverter() {
        return this.getColumn().map(Column::converter).map(converterClass -> (IConverter)Reflect.onClass((Class)converterClass).create().get()).filter(converterInstance -> converterInstance.getType().equals(this.getFieldType())).orElseGet(() -> (IConverter)StreamEx.of(this.defaultIConverters).findFirst(converterInstance -> converterInstance.getType().equals(this.getFieldType())).orElseThrow(() -> new IllegalStateException(String.format("There's no matching converter found for %s field of type %s", this.getFieldName(), this.getFieldType()))));
    }
}

