/*
 * Decompiled with CFR 0.152.
 */
package io.github.sskorol.data;

import io.github.sskorol.converters.BooleanConverter;
import io.github.sskorol.converters.DoubleConverter;
import io.github.sskorol.converters.IConverter;
import io.github.sskorol.converters.IntegerConverter;
import io.github.sskorol.converters.LocalDateConverter;
import io.github.sskorol.converters.LocalDateTimeConverter;
import io.github.sskorol.converters.StringConverter;
import io.github.sskorol.data.DataReader;
import io.github.sskorol.data.Sheet;
import io.github.sskorol.data.XlsxCellMapper;
import io.vavr.Tuple;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.joor.Reflect;

public class XlsxReader<T>
implements DataReader<T> {
    private final Class<T> entityClass;
    private final String path;
    private final List<IConverter<T>> defaultIConverters;
    private final List<String> sheetNames;

    public XlsxReader(Class<T> entityClass, String path) {
        this.entityClass = entityClass;
        this.path = path;
        this.defaultIConverters = XlsxReader.defaultConverters();
        this.sheetNames = new ArrayList<String>();
    }

    public XlsxReader(Class<T> entityClass) {
        this(entityClass, "");
    }

    public static <T> List<IConverter<T>> defaultConverters() {
        return StreamEx.of((Object[])new Class[]{BooleanConverter.class, StringConverter.class, IntegerConverter.class, DoubleConverter.class, LocalDateConverter.class, LocalDateTimeConverter.class}).map(cls -> (IConverter)Reflect.onClass((Class)cls).create().get()).toList();
    }

    @Override
    public StreamEx<T> read() {
        StreamEx streamEx;
        block9: {
            Workbook workbook = WorkbookFactory.create((InputStream)this.getUrl().openStream());
            try {
                DataFormatter formatter = new DataFormatter();
                int startIndex = 0;
                int skip = 1;
                List sheets = this.getSheetNames().map(arg_0 -> ((Workbook)workbook).getSheet(arg_0)).toMutableList();
                if (sheets.isEmpty()) {
                    sheets.add(workbook.getSheetAt(startIndex));
                }
                streamEx = StreamEx.of((Collection)sheets).flatMap(sheet -> ((StreamEx)((StreamEx)StreamEx.of((Iterator)sheet.iterator()).skip((long)skip)).filter(row -> !this.isRowEmpty((Row)row))).map(this.mappersOf((org.apache.poi.ss.usermodel.Sheet)sheet, startIndex, formatter)).map(this::initEntity));
                if (workbook == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (workbook != null) {
                        try {
                            workbook.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException(String.format("Unable to read XLSX data to %s.", this.entityClass), ex);
                }
            }
            workbook.close();
        }
        return streamEx;
    }

    public T initEntity(List<XlsxCellMapper<T>> mappers) {
        boolean hasDefaultConstructor = StreamEx.of((Object[])this.entityClass.getDeclaredConstructors()).anyMatch(constructor -> constructor.getParameterCount() == 0);
        if (!hasDefaultConstructor) {
            throw new IllegalStateException(String.format("%s must have default constructor.", this.entityClass.getSimpleName()));
        }
        Object entity = Reflect.onClass(this.entityClass).create().get();
        StreamEx.of(mappers).forEach(mapper -> mapper.assignValue(entity));
        return (T)entity;
    }

    @Override
    public XlsxReader<T> additionalSources(List<String> names) {
        this.sheetNames.addAll(names);
        return this;
    }

    private Function<Row, List<XlsxCellMapper<T>>> mappersOf(org.apache.poi.ss.usermodel.Sheet sheet, int startIndex, DataFormatter formatter) {
        Map headers = ((StreamEx)StreamEx.of((Iterator)sheet.getRow(startIndex).cellIterator()).map(cell -> Tuple.of((Object)cell, (Object)formatter.formatCellValue(cell).trim())).filter(cell -> !((String)cell._2).isEmpty())).toMap(cell -> (String)cell._2, pair -> ((Cell)pair._1).getColumnIndex());
        return row -> StreamEx.of((Object[])this.entityClass.getDeclaredFields()).map(field -> new XlsxCellMapper<T>((Field)field, headers, this.defaultIConverters)).map(cellMapper -> cellMapper.parse((Row)row)).toList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isRowEmpty(Row row) {
        if (row == null) return true;
        if (row.getLastCellNum() <= 0) return true;
        if (!((StreamEx)IntStreamEx.range((int)row.getFirstCellNum(), (int)row.getLastCellNum()).mapToObj(arg_0 -> ((Row)row).getCell(arg_0)).filter(Objects::nonNull)).noneMatch(cell -> cell.getCellType() != CellType.BLANK && !cell.toString().isEmpty())) return false;
        return true;
    }

    private StreamEx<String> getSheetNames() {
        return !this.sheetNames.isEmpty() ? StreamEx.of(this.sheetNames) : StreamEx.of((Object[])((Sheet[])this.entityClass.getAnnotationsByType(Sheet.class))).map(Sheet::name);
    }

    @Override
    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public String getPath() {
        return this.path;
    }
}

