/*
 * Decompiled with CFR 0.152.
 */
package io.github.sskorol.model;

import io.github.sskorol.core.DataSupplier;
import io.github.sskorol.model.TestNGMethod;
import io.github.sskorol.utils.ReflectionUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import one.util.streamex.EntryStream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;

public class DataSupplierMetaData {
    private final List<Object[]> testData;
    private final boolean transpose;
    private final boolean flatMap;
    private final int[] indices;
    private final TestNGMethod testNGMethod;

    public DataSupplierMetaData(ITestContext context, ITestNGMethod testMethod) {
        this.testNGMethod = new TestNGMethod(context, testMethod);
        this.transpose = this.testNGMethod.getDataSupplierArg(DataSupplier::transpose, false);
        this.flatMap = this.testNGMethod.getDataSupplierArg(DataSupplier::flatMap, false);
        this.indices = this.testNGMethod.getDataSupplierArg(DataSupplier::indices, new int[0]);
        this.testData = this.transform();
    }

    private List<Object[]> transform() {
        Object returnValue = this.obtainReturnValue();
        List data = ReflectionUtils.streamOf(returnValue).toList();
        List<Integer> indicesList = this.indicesList(data.size());
        StreamEx wrappedReturnValue = EntryStream.of((List)data).filterKeys(indicesList::contains).values();
        if (this.transpose) {
            if (returnValue instanceof Collection || returnValue instanceof Map) {
                Object[] objectArray;
                if (this.flatMap) {
                    objectArray = wrappedReturnValue.toArray();
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = returnValue;
                }
                return Collections.singletonList(objectArray);
            }
            return Collections.singletonList(this.flatMap ? ((StreamEx)wrappedReturnValue.filter(Objects::nonNull)).flatMap(ReflectionUtils::streamOf).toArray() : wrappedReturnValue.toArray());
        }
        return wrappedReturnValue.map(ob -> {
            Object[] objectArray;
            if (this.flatMap) {
                objectArray = ReflectionUtils.streamOf(ob).toArray();
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = ob;
            }
            return objectArray;
        }).toList();
    }

    private Object obtainReturnValue() {
        return ReflectionUtils.invokeDataSupplier(this.testNGMethod.getDataSupplierMetaData());
    }

    private List<Integer> indicesList(int collectionSize) {
        return Optional.ofNullable(this.indices).filter(indicesArray -> ((int[])indicesArray).length > 0).map(IntStreamEx::of).orElseGet(() -> IntStreamEx.range((int)0, (int)collectionSize)).boxed().toList();
    }

    public List<Object[]> getTestData() {
        return this.testData;
    }

    public TestNGMethod getTestNGMethod() {
        return this.testNGMethod;
    }
}

