/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.Batch;
import io.github.stefanbratanov.jvm.openai.CreateBatchRequest;
import io.github.stefanbratanov.jvm.openai.Endpoint;
import io.github.stefanbratanov.jvm.openai.OpenAIClient;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class BatchClient
extends OpenAIClient {
    private final URI baseUrl;

    BatchClient(URI baseUrl, String[] authenticationHeaders, HttpClient httpClient, Optional<Duration> requestTimeout) {
        super(authenticationHeaders, httpClient, requestTimeout);
        this.baseUrl = baseUrl;
    }

    public Batch createBatch(CreateBatchRequest request) {
        HttpRequest httpRequest = this.newHttpRequestBuilder("Content-Type", "application/json").uri(this.baseUrl.resolve(Endpoint.BATCHES.getPath())).POST(this.createBodyPublisher(request)).build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), Batch.class);
    }

    public Batch retrieveBatch(String batchId) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.BATCHES.getPath() + "/" + batchId)).GET().build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), Batch.class);
    }

    public Batch cancelBatch(String batchId) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.BATCHES.getPath() + "/" + batchId + "/cancel")).POST(HttpRequest.BodyPublishers.noBody()).build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), Batch.class);
    }

    public PaginatedBatches listBatches(Optional<String> after, Optional<String> limit) {
        String queryParameters = this.createQueryParameters(Map.of("limit", limit, "after", after));
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.BATCHES.getPath() + queryParameters)).GET().build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), PaginatedBatches.class);
    }

    public record PaginatedBatches(List<Batch> data, String firstId, String lastId, boolean hasMore) {
    }
}

