/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.ChatCompletion;
import io.github.stefanbratanov.jvm.openai.ChatCompletionChunk;
import io.github.stefanbratanov.jvm.openai.ChatCompletionStreamSubscriber;
import io.github.stefanbratanov.jvm.openai.CreateChatCompletionRequest;
import io.github.stefanbratanov.jvm.openai.Endpoint;
import io.github.stefanbratanov.jvm.openai.OpenAIClient;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

public final class ChatClient
extends OpenAIClient {
    private final URI endpoint;

    ChatClient(URI baseUrl, String[] authenticationHeaders, HttpClient httpClient, Optional<Duration> requestTimeout) {
        super(authenticationHeaders, httpClient, requestTimeout);
        this.endpoint = baseUrl.resolve(Endpoint.CHAT.getPath());
    }

    public ChatCompletion createChatCompletion(CreateChatCompletionRequest request) {
        HttpRequest httpRequest = this.createPostRequest(request);
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), ChatCompletion.class);
    }

    public CompletableFuture<ChatCompletion> createChatCompletionAsync(CreateChatCompletionRequest request) {
        HttpRequest httpRequest = this.createPostRequest(request);
        return this.sendHttpRequestAsync(httpRequest).thenApply(httpResponse -> this.deserializeResponse((byte[])httpResponse.body(), ChatCompletion.class));
    }

    public Stream<ChatCompletionChunk> streamChatCompletion(CreateChatCompletionRequest request) {
        this.validateStreamRequest(request::stream);
        HttpRequest httpRequest = this.createPostRequest(request);
        return this.getStreamedChatCompletionChunks(httpRequest);
    }

    public void streamChatCompletion(CreateChatCompletionRequest request, ChatCompletionStreamSubscriber subscriber) {
        this.validateStreamRequest(request::stream);
        HttpRequest httpRequest = this.createPostRequest(request);
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.getStreamedChatCompletionChunks(httpRequest)).thenAccept(chatCompletionChunks -> chatCompletionChunks.forEach(subscriber::onChunk))).whenComplete((result, ex) -> {
            if (ex != null) {
                subscriber.onException((Throwable)ex);
            }
            subscriber.onComplete();
        });
    }

    private HttpRequest createPostRequest(CreateChatCompletionRequest request) {
        return this.newHttpRequestBuilder("Content-Type", "application/json", "Accept", "application/json").uri(this.endpoint).POST(this.createBodyPublisher(request)).build();
    }

    private Stream<ChatCompletionChunk> getStreamedChatCompletionChunks(HttpRequest httpRequest) {
        return this.streamServerSentEvents(httpRequest).map(sseEvent -> {
            String data = sseEvent.substring(sseEvent.indexOf("{"));
            return this.deserializeData(data, ChatCompletionChunk.class);
        });
    }
}

