/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.stefanbratanov.jvm.openai.ContentPart;
import io.github.stefanbratanov.jvm.openai.Role;
import io.github.stefanbratanov.jvm.openai.ToolCall;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ChatMessage {
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public String role();

    public static SystemMessage systemMessage(String content) {
        return new SystemMessage(content, Optional.empty());
    }

    public static UserMessage.UserMessageWithTextContent userMessage(String content) {
        return new UserMessage.UserMessageWithTextContent(content, Optional.empty());
    }

    public static UserMessage.UserMessageWithContentParts userMessage(ContentPart ... content) {
        return new UserMessage.UserMessageWithContentParts(Arrays.asList(content), Optional.empty());
    }

    public static AssistantMessage assistantMessage(String content) {
        return new AssistantMessage(content, Optional.empty(), Optional.empty());
    }

    public static AssistantMessage assistantMessage(String content, List<ToolCall> toolCalls) {
        return new AssistantMessage(content, Optional.empty(), Optional.of(toolCalls));
    }

    public static ToolMessage toolMessage(String content, String toolCallId) {
        return new ToolMessage(content, toolCallId);
    }

    public record SystemMessage(String content, Optional<String> name) implements ChatMessage
    {
        @Override
        public String role() {
            return Role.SYSTEM.getId();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface UserMessage<T>
    extends ChatMessage {
        @Override
        default public String role() {
            return Role.USER.getId();
        }

        public T content();

        public static final class UserMessageWithContentParts
        extends Record
        implements UserMessage<List<ContentPart>> {
            private final List<ContentPart> content;
            private final Optional<String> name;

            public UserMessageWithContentParts(List<ContentPart> content, Optional<String> name) {
                this.content = content;
                this.name = name;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{UserMessageWithContentParts.class, "content;name", "content", "name"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{UserMessageWithContentParts.class, "content;name", "content", "name"}, this);
            }

            @Override
            public final boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{UserMessageWithContentParts.class, "content;name", "content", "name"}, this, o);
            }

            @Override
            public List<ContentPart> content() {
                return this.content;
            }

            public Optional<String> name() {
                return this.name;
            }
        }

        public static final class UserMessageWithTextContent
        extends Record
        implements UserMessage<String> {
            private final String content;
            private final Optional<String> name;

            public UserMessageWithTextContent(String content, Optional<String> name) {
                this.content = content;
                this.name = name;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{UserMessageWithTextContent.class, "content;name", "content", "name"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{UserMessageWithTextContent.class, "content;name", "content", "name"}, this);
            }

            @Override
            public final boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{UserMessageWithTextContent.class, "content;name", "content", "name"}, this, o);
            }

            @Override
            public String content() {
                return this.content;
            }

            public Optional<String> name() {
                return this.name;
            }
        }
    }

    public record AssistantMessage(String content, Optional<String> name, Optional<List<ToolCall>> toolCalls) implements ChatMessage
    {
        @Override
        public String role() {
            return Role.ASSISTANT.getId();
        }
    }

    public record ToolMessage(String content, String toolCallId) implements ChatMessage
    {
        @Override
        public String role() {
            return Role.TOOL.getId();
        }
    }
}

