/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Optional;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", include=JsonTypeInfo.As.EXISTING_PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=TextContentPart.class, name="text"), @JsonSubTypes.Type(value=ImageUrlContentPart.class, name="image_url"), @JsonSubTypes.Type(value=ImageFileContentPart.class, name="image_file")})
public interface ContentPart {
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public String type();

    public static TextContentPart textContentPart(String text) {
        return new TextContentPart(text);
    }

    public static ImageUrlContentPart imageUrlContentPart(String url) {
        return new ImageUrlContentPart(new ImageUrlContentPart.ImageUrl(url, Optional.empty()));
    }

    public static ImageUrlContentPart imageUrlContentPart(String url, String detail) {
        return new ImageUrlContentPart(new ImageUrlContentPart.ImageUrl(url, Optional.of(detail)));
    }

    public static ImageFileContentPart imageFileContentPart(String fileId) {
        return new ImageFileContentPart(new ImageFileContentPart.ImageFile(fileId, Optional.empty()));
    }

    public static ImageFileContentPart imageFileContentPart(String fileId, String detail) {
        return new ImageFileContentPart(new ImageFileContentPart.ImageFile(fileId, Optional.of(detail)));
    }

    public record TextContentPart(String text) implements ContentPart
    {
        @Override
        public String type() {
            return "text";
        }
    }

    public record ImageUrlContentPart(ImageUrl imageUrl) implements ContentPart
    {
        @Override
        public String type() {
            return "image_url";
        }

        public record ImageUrl(String url, Optional<String> detail) {
        }
    }

    public record ImageFileContentPart(ImageFile imageFile) implements ContentPart
    {
        @Override
        public String type() {
            return "image_file";
        }

        public record ImageFile(String fileId, Optional<String> detail) {
        }
    }
}

