/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.FineTuningJobIntegration;
import io.github.stefanbratanov.jvm.openai.OpenAIModel;
import java.util.List;
import java.util.Optional;

public record CreateFineTuningJobRequest(String model, String trainingFile, Optional<Hyperparameters> hyperparameters, Optional<String> suffix, Optional<String> validationFile, Optional<List<FineTuningJobIntegration>> integrations, Optional<Integer> seed) {
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String model;
        private String trainingFile;
        private Optional<Hyperparameters> hyperparameters = Optional.empty();
        private Optional<String> suffix = Optional.empty();
        private Optional<String> validationFile = Optional.empty();
        private Optional<List<FineTuningJobIntegration>> integrations = Optional.empty();
        private Optional<Integer> seed = Optional.empty();

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder model(OpenAIModel model) {
            this.model = model.getId();
            return this;
        }

        public Builder trainingFile(String trainingFile) {
            this.trainingFile = trainingFile;
            return this;
        }

        public Builder hyperparameters(Hyperparameters hyperparameters) {
            this.hyperparameters = Optional.of(hyperparameters);
            return this;
        }

        public Builder suffix(String suffix) {
            this.suffix = Optional.of(suffix);
            return this;
        }

        public Builder validationFile(String validationFile) {
            this.validationFile = Optional.of(validationFile);
            return this;
        }

        public Builder integrations(List<FineTuningJobIntegration> integrations) {
            this.integrations = Optional.of(integrations);
            return this;
        }

        public Builder seed(int seed) {
            this.seed = Optional.of(seed);
            return this;
        }

        public CreateFineTuningJobRequest build() {
            return new CreateFineTuningJobRequest(this.model, this.trainingFile, this.hyperparameters, this.suffix, this.validationFile, this.integrations, this.seed);
        }
    }

    public record Hyperparameters(Optional<Object> batchSize, Optional<Object> learningRateMultiplier, Optional<Object> nEpochs) {
        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private Optional<Object> batchSize = Optional.empty();
            private Optional<Object> learningRateMultiplier = Optional.empty();
            private Optional<Object> nEpochs = Optional.empty();

            public Builder batchSize(String batchSize) {
                this.batchSize = Optional.of(batchSize);
                return this;
            }

            public Builder batchSize(int batchSize) {
                this.batchSize = Optional.of(batchSize);
                return this;
            }

            public Builder learningRateMultiplier(String learningRateMultiplier) {
                this.learningRateMultiplier = Optional.of(learningRateMultiplier);
                return this;
            }

            public Builder learningRateMultiplier(double learningRateMultiplier) {
                this.learningRateMultiplier = Optional.of(learningRateMultiplier);
                return this;
            }

            public Builder nEpochs(String nEpochs) {
                this.nEpochs = Optional.of(nEpochs);
                return this;
            }

            public Builder nEpochs(int nEpochs) {
                this.nEpochs = Optional.of(nEpochs);
                return this;
            }

            public Hyperparameters build() {
                return new Hyperparameters(this.batchSize, this.learningRateMultiplier, this.nEpochs);
            }
        }
    }
}

