/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.Attachment;
import io.github.stefanbratanov.jvm.openai.Role;
import io.github.stefanbratanov.jvm.openai.ToolResources;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public record CreateThreadRequest(Optional<List<Message>> messages, Optional<ToolResources> toolResources, Optional<Map<String, String>> metadata) {
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final List<Message> messages = new LinkedList<Message>();
        private Optional<ToolResources> toolResources = Optional.empty();
        private Optional<Map<String, String>> metadata = Optional.empty();

        public Builder message(Message message) {
            this.messages.add(message);
            return this;
        }

        public Builder messages(List<Message> messages) {
            this.messages.addAll(messages);
            return this;
        }

        public Builder toolResources(ToolResources toolResources) {
            this.toolResources = Optional.of(toolResources);
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = Optional.of(metadata);
            return this;
        }

        public CreateThreadRequest build() {
            return new CreateThreadRequest(this.messages.isEmpty() ? Optional.empty() : Optional.of(List.copyOf(this.messages)), this.toolResources, this.metadata);
        }
    }

    public record Message(String role, String content, Optional<List<Attachment>> attachments, Optional<Map<String, String>> metadata) {
        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private String role = Role.USER.getId();
            private String content;
            private Optional<List<Attachment>> attachments = Optional.empty();
            private Optional<Map<String, String>> metadata = Optional.empty();

            public Builder role(String role) {
                this.role = role;
                return this;
            }

            public Builder role(Role role) {
                this.role = role.getId();
                return this;
            }

            public Builder content(String content) {
                this.content = content;
                return this;
            }

            public Builder attachments(List<Attachment> attachments) {
                this.attachments = Optional.of(attachments);
                return this;
            }

            public Builder metadata(Map<String, String> metadata) {
                this.metadata = Optional.of(metadata);
                return this;
            }

            public Message build() {
                return new Message(this.role, this.content, this.attachments, this.metadata);
            }
        }
    }
}

