/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.ChunkingStrategy;
import java.util.Optional;

public record CreateVectorStoreFileRequest(String fileId, Optional<ChunkingStrategy> chunkingStrategy) {
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String fileId;
        private Optional<ChunkingStrategy> chunkingStrategy = Optional.empty();

        public Builder fileId(String fileId) {
            this.fileId = fileId;
            return this;
        }

        public Builder chunkingStrategy(ChunkingStrategy chunkingStrategy) {
            this.chunkingStrategy = Optional.of(chunkingStrategy);
            return this;
        }

        public CreateVectorStoreFileRequest build() {
            return new CreateVectorStoreFileRequest(this.fileId, this.chunkingStrategy);
        }
    }
}

