/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.DeletionStatus;
import io.github.stefanbratanov.jvm.openai.Endpoint;
import io.github.stefanbratanov.jvm.openai.File;
import io.github.stefanbratanov.jvm.openai.MultipartBodyPublisher;
import io.github.stefanbratanov.jvm.openai.OpenAIClient;
import io.github.stefanbratanov.jvm.openai.UploadFileRequest;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

public final class FilesClient
extends OpenAIClient {
    private final URI baseUrl;

    FilesClient(URI baseUrl, String[] authenticationHeaders, HttpClient httpClient, Optional<Duration> requestTimeout) {
        super(authenticationHeaders, httpClient, requestTimeout);
        this.baseUrl = baseUrl;
    }

    public File uploadFile(UploadFileRequest request) {
        MultipartBodyPublisher multipartBodyPublisher = MultipartBodyPublisher.newBuilder().filePart("file", request.file()).textPart("purpose", request.purpose()).build();
        HttpRequest httpRequest = this.newHttpRequestBuilder("Content-Type", multipartBodyPublisher.getContentTypeHeader()).uri(this.baseUrl.resolve(Endpoint.FILES.getPath())).POST(multipartBodyPublisher).build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), File.class);
    }

    public List<File> listFiles() {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.FILES.getPath())).GET().build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeDataInResponseAsList(httpResponse.body(), File.class);
    }

    public File retrieveFile(String fileId) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.FILES.getPath() + "/" + fileId)).GET().build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), File.class);
    }

    public DeletionStatus deleteFile(String fileId) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.FILES.getPath() + "/" + fileId)).DELETE().build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), DeletionStatus.class);
    }

    public byte[] retrieveFileContent(String fileId) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.FILES.getPath() + "/" + fileId + "/content")).GET().build();
        return this.sendHttpRequest(httpRequest).body();
    }
}

