/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.CreateImageRequest;
import io.github.stefanbratanov.jvm.openai.CreateImageVariationRequest;
import io.github.stefanbratanov.jvm.openai.EditImageRequest;
import io.github.stefanbratanov.jvm.openai.Endpoint;
import io.github.stefanbratanov.jvm.openai.Images;
import io.github.stefanbratanov.jvm.openai.MultipartBodyPublisher;
import io.github.stefanbratanov.jvm.openai.OpenAIClient;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public final class ImagesClient
extends OpenAIClient {
    private final URI baseUrl;

    ImagesClient(URI baseUrl, String[] authenticationHeaders, HttpClient httpClient, Optional<Duration> requestTimeout) {
        super(authenticationHeaders, httpClient, requestTimeout);
        this.baseUrl = baseUrl;
    }

    public Images createImage(CreateImageRequest request) {
        HttpRequest httpRequest = this.createImagePostRequest(request);
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), Images.class);
    }

    public CompletableFuture<Images> createImageAsync(CreateImageRequest request) {
        HttpRequest httpRequest = this.createImagePostRequest(request);
        return this.sendHttpRequestAsync(httpRequest).thenApply(httpResponse -> this.deserializeResponse((byte[])httpResponse.body(), Images.class));
    }

    public Images editImage(EditImageRequest request) {
        HttpRequest httpRequest = this.editImagePostRequest(request);
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), Images.class);
    }

    public CompletableFuture<Images> editImageAsync(EditImageRequest request) {
        HttpRequest httpRequest = this.editImagePostRequest(request);
        return this.sendHttpRequestAsync(httpRequest).thenApply(httpResponse -> this.deserializeResponse((byte[])httpResponse.body(), Images.class));
    }

    public Images createImageVariation(CreateImageVariationRequest request) {
        HttpRequest httpRequest = this.createImageVariationPostRequest(request);
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), Images.class);
    }

    public CompletableFuture<Images> createImageVariationAsync(CreateImageVariationRequest request) {
        HttpRequest httpRequest = this.createImageVariationPostRequest(request);
        return this.sendHttpRequestAsync(httpRequest).thenApply(httpResponse -> this.deserializeResponse((byte[])httpResponse.body(), Images.class));
    }

    private HttpRequest createImagePostRequest(CreateImageRequest request) {
        return this.newHttpRequestBuilder("Content-Type", "application/json").uri(this.baseUrl.resolve(Endpoint.IMAGE_GENERATION.getPath())).POST(this.createBodyPublisher(request)).build();
    }

    private HttpRequest editImagePostRequest(EditImageRequest request) {
        MultipartBodyPublisher.Builder multipartBodyPublisherBuilder = MultipartBodyPublisher.newBuilder().filePart("image", request.image()).textPart("prompt", request.prompt());
        request.mask().ifPresent(mask -> multipartBodyPublisherBuilder.filePart("mask", (Path)mask));
        request.model().ifPresent(model -> multipartBodyPublisherBuilder.textPart("model", model));
        request.n().ifPresent(n -> multipartBodyPublisherBuilder.textPart("n", n));
        request.size().ifPresent(size -> multipartBodyPublisherBuilder.textPart("size", size));
        request.responseFormat().ifPresent(responseFormat -> multipartBodyPublisherBuilder.textPart("response_format", responseFormat));
        request.user().ifPresent(user -> multipartBodyPublisherBuilder.textPart("user", user));
        MultipartBodyPublisher multipartBodyPublisher = multipartBodyPublisherBuilder.build();
        return this.newHttpRequestBuilder("Content-Type", multipartBodyPublisher.getContentTypeHeader()).uri(this.baseUrl.resolve(Endpoint.IMAGE_EDIT.getPath())).POST(multipartBodyPublisher).build();
    }

    private HttpRequest createImageVariationPostRequest(CreateImageVariationRequest request) {
        MultipartBodyPublisher.Builder multipartBodyPublisherBuilder = MultipartBodyPublisher.newBuilder().filePart("image", request.image());
        request.model().ifPresent(model -> multipartBodyPublisherBuilder.textPart("model", model));
        request.responseFormat().ifPresent(responseFormat -> multipartBodyPublisherBuilder.textPart("response_format", responseFormat));
        request.n().ifPresent(n -> multipartBodyPublisherBuilder.textPart("n", n));
        request.size().ifPresent(size -> multipartBodyPublisherBuilder.textPart("size", size));
        request.user().ifPresent(user -> multipartBodyPublisherBuilder.textPart("user", user));
        MultipartBodyPublisher multipartBodyPublisher = multipartBodyPublisherBuilder.build();
        return this.newHttpRequestBuilder("Content-Type", multipartBodyPublisher.getContentTypeHeader()).uri(this.baseUrl.resolve(Endpoint.IMAGE_VARIATION.getPath())).POST(multipartBodyPublisher).build();
    }
}

