/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Flow;

class MultipartBodyPublisher
implements HttpRequest.BodyPublisher {
    private final String boundary;
    private final List<byte[]> multipartBodyParts;

    private MultipartBodyPublisher(String boundary, List<byte[]> multipartBodyParts) {
        this.boundary = boundary;
        this.multipartBodyParts = multipartBodyParts;
    }

    @Override
    public long contentLength() {
        return this.multipartBodyParts.stream().mapToInt(bodyPart -> ((byte[])bodyPart).length).sum();
    }

    @Override
    public void subscribe(final Flow.Subscriber<? super ByteBuffer> subscriber) {
        subscriber.onSubscribe(new Flow.Subscription(){
            private int index = 0;

            @Override
            public void request(long n) {
                long elementsToEmit = Math.min(n, (long)MultipartBodyPublisher.this.multipartBodyParts.size() - (long)this.index);
                int i = 0;
                while ((long)i < elementsToEmit) {
                    subscriber.onNext(ByteBuffer.wrap(MultipartBodyPublisher.this.multipartBodyParts.get(this.index++)));
                    ++i;
                }
                if (this.index == MultipartBodyPublisher.this.multipartBodyParts.size()) {
                    subscriber.onComplete();
                }
            }

            @Override
            public void cancel() {
            }
        });
    }

    String getContentTypeHeader() {
        return "multipart/form-data; boundary=" + this.boundary;
    }

    static Builder newBuilder() {
        return new Builder();
    }

    static class Builder {
        private static final String CRLF = "\r\n";
        private final String boundary;
        private final String separator;
        private final List<byte[]> multipartBodyParts = new ArrayList<byte[]>();

        Builder() {
            this.boundary = UUID.randomUUID().toString();
            this.separator = "--" + this.boundary + "\r\nContent-Disposition: form-data; name=";
        }

        Builder textPart(String key, Object value) {
            this.multipartBodyParts.add((this.separator + "\"" + key + "\"\r\n\r\n" + value + CRLF).getBytes());
            return this;
        }

        Builder filePart(String key, Path value) {
            try {
                String mimeType = Files.probeContentType(value);
                byte[] fileBytes = Files.readAllBytes(value);
                this.multipartBodyParts.add((this.separator + "\"" + key + "\"; filename=\"" + value.getFileName() + "\"\r\nContent-Type: " + mimeType + "\r\nContent-Length: " + fileBytes.length + "\r\n\r\n").getBytes());
                this.multipartBodyParts.add(fileBytes);
                this.multipartBodyParts.add(CRLF.getBytes());
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            return this;
        }

        MultipartBodyPublisher build() {
            this.multipartBodyParts.add(("--" + this.boundary + "--").getBytes());
            return new MultipartBodyPublisher(this.boundary, this.multipartBodyParts);
        }
    }
}

