/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.OpenAIClient;
import io.github.stefanbratanov.jvm.openai.PaginationQueryParameters;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

class OpenAIAssistantsClient
extends OpenAIClient {
    OpenAIAssistantsClient(String[] authenticationHeaders, HttpClient httpClient, Optional<Duration> requestTimeout) {
        super(authenticationHeaders, httpClient, requestTimeout);
    }

    @Override
    HttpRequest.Builder newHttpRequestBuilder(String ... headers) {
        return super.newHttpRequestBuilder(headers).header("OpenAI-Beta", "assistants=v2");
    }

    String createQueryParameters(PaginationQueryParameters paginationQueryParameters) {
        return this.createQueryParameters(paginationQueryParameters, Collections.emptyMap());
    }

    String createQueryParameters(PaginationQueryParameters paginationQueryParameters, Map<String, Optional<?>> additionalQueryParameters) {
        HashMap queryParameters = new HashMap();
        queryParameters.put("limit", paginationQueryParameters.limit());
        queryParameters.put("order", paginationQueryParameters.order());
        queryParameters.put("after", paginationQueryParameters.after());
        queryParameters.put("before", paginationQueryParameters.before());
        queryParameters.putAll(additionalQueryParameters);
        return this.createQueryParameters(queryParameters);
    }
}

