/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

public final class OpenAIException
extends RuntimeException {
    private final int statusCode;
    private final Error error;

    OpenAIException(int statusCode, Error error) {
        super(String.format("%d - %s", statusCode, error));
        this.statusCode = statusCode;
        this.error = error;
    }

    public int statusCode() {
        return this.statusCode;
    }

    public String errorMessage() {
        return this.error.message();
    }

    public Error error() {
        return this.error;
    }

    public record Error(String message, String type, String param, String code) {
        @Override
        public String toString() {
            return String.format("message: %s, type: %s, param: %s, code: %s", this.message, this.type, this.param, this.code);
        }
    }
}

