/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.Endpoint;
import io.github.stefanbratanov.jvm.openai.OpenAIAssistantsClient;
import io.github.stefanbratanov.jvm.openai.PaginationQueryParameters;
import io.github.stefanbratanov.jvm.openai.ThreadRunStep;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

public final class RunStepsClient
extends OpenAIAssistantsClient {
    private static final String RUNS_SEGMENT = "/runs";
    private static final String STEPS_SEGMENT = "/steps";
    private final URI baseUrl;

    RunStepsClient(URI baseUrl, String[] authenticationHeaders, HttpClient httpClient, Optional<Duration> requestTimeout) {
        super(authenticationHeaders, httpClient, requestTimeout);
        this.baseUrl = baseUrl;
    }

    public PaginatedThreadRunSteps listRunSteps(String threadId, String runId, PaginationQueryParameters paginationQueryParameters) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.THREADS.getPath() + "/" + threadId + "/runs/" + runId + STEPS_SEGMENT + this.createQueryParameters(paginationQueryParameters))).GET().build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), PaginatedThreadRunSteps.class);
    }

    public ThreadRunStep retrieveRunStep(String threadId, String runId, String stepId) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.THREADS.getPath() + "/" + threadId + "/runs/" + runId + "/steps/" + stepId)).GET().build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), ThreadRunStep.class);
    }

    public record PaginatedThreadRunSteps(List<ThreadRunStep> data, String firstId, String lastId, boolean hasMore) {
    }
}

