/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.OpenAIModel;
import io.github.stefanbratanov.jvm.openai.Voice;
import java.util.Optional;

public record SpeechRequest(String model, String input, String voice, Optional<String> responseFormat, Optional<Double> speed) {
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private static final String DEFAULT_MODEL = OpenAIModel.TTS_1.getId();
        private static final String DEFAULT_VOICE = Voice.ALLOY.getId();
        private String model = DEFAULT_MODEL;
        private String input;
        private String voice = DEFAULT_VOICE;
        private Optional<String> responseFormat;
        private Optional<Double> speed;

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder model(OpenAIModel model) {
            this.model = model.getId();
            return this;
        }

        public Builder input(String input) {
            this.input = input;
            return this;
        }

        public Builder voice(String voice) {
            this.voice = voice;
            return this;
        }

        public Builder voice(Voice voice) {
            this.voice = voice.getId();
            return this;
        }

        public Builder responseFormat(String responseFormat) {
            this.responseFormat = Optional.of(responseFormat);
            return this;
        }

        public Builder speed(double speed) {
            this.speed = Optional.of(speed);
            return this;
        }

        public SpeechRequest build() {
            return new SpeechRequest(this.model, this.input, this.voice, this.responseFormat, this.speed);
        }
    }
}

