/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.github.stefanbratanov.jvm.openai.AssistantStreamEvent;
import io.github.stefanbratanov.jvm.openai.Attachment;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public record ThreadMessage(String id, long createdAt, String threadId, String status, IncompleteDetails incompleteDetails, Long completedAt, Long incompleteAt, String role, List<Content> content, String assistantId, String runId, List<Attachment> attachments, Map<String, String> metadata) implements AssistantStreamEvent.Data
{

    public record IncompleteDetails(String reason) {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", include=JsonTypeInfo.As.EXISTING_PROPERTY)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=ImageFileContent.class, name="image_file"), @JsonSubTypes.Type(value=ImageUrlContent.class, name="image_url"), @JsonSubTypes.Type(value=TextContent.class, name="text")})
    public static interface Content {
        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        public String type();

        public record TextContent(Text text) implements Content
        {
            @Override
            public String type() {
                return "text";
            }

            public record Text(String value, List<Annotation> annotations) {

                /*
                 * Uses 'sealed' constructs - enablewith --sealed true
                 */
                @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", include=JsonTypeInfo.As.EXISTING_PROPERTY)
                @JsonSubTypes(value={@JsonSubTypes.Type(value=FileCitationAnnotation.class, name="file_citation"), @JsonSubTypes.Type(value=FilePathAnnotation.class, name="file_path")})
                public static interface Annotation {
                    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
                    public String type();

                    public String text();

                    public int startIndex();

                    public int endIndex();

                    public record FilePathAnnotation(String text, FilePath filePath, int startIndex, int endIndex) implements Annotation
                    {
                        @Override
                        public String type() {
                            return "file_path";
                        }

                        public record FilePath(String fileId) {
                        }
                    }

                    public record FileCitationAnnotation(String text, FileCitation fileCitation, int startIndex, int endIndex) implements Annotation
                    {
                        @Override
                        public String type() {
                            return "file_citation";
                        }

                        public record FileCitation(String fileId) {
                        }
                    }
                }
            }
        }

        public record ImageUrlContent(ImageUrl imageUrl) implements Content
        {
            @Override
            public String type() {
                return "image_url";
            }

            public record ImageUrl(String url, Optional<String> detail) {
            }
        }

        public record ImageFileContent(ImageFile imageFile) implements Content
        {
            @Override
            public String type() {
                return "image_file";
            }

            public record ImageFile(String fileId, Optional<String> detail) {
            }
        }
    }
}

