/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.github.stefanbratanov.jvm.openai.AssistantStreamEvent;
import java.util.List;
import java.util.Optional;

public record ThreadMessageDelta(String id, Delta delta) implements AssistantStreamEvent.Data
{

    public record Delta(String role, List<Content> content) {

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", include=JsonTypeInfo.As.EXISTING_PROPERTY)
        @JsonSubTypes(value={@JsonSubTypes.Type(value=ImageFileContent.class, name="image_file"), @JsonSubTypes.Type(value=ImageUrlContent.class, name="image_url"), @JsonSubTypes.Type(value=TextContent.class, name="text")})
        public static interface Content {
            public int index();

            @JsonProperty(access=JsonProperty.Access.READ_ONLY)
            public String type();

            public record TextContent(int index, Text text) implements Content
            {
                @Override
                public String type() {
                    return "text";
                }

                public record Text(String value, List<Annotation> annotations) {

                    /*
                     * Uses 'sealed' constructs - enablewith --sealed true
                     */
                    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", include=JsonTypeInfo.As.EXISTING_PROPERTY)
                    @JsonSubTypes(value={@JsonSubTypes.Type(value=FileCitationAnnotation.class, name="file_citation"), @JsonSubTypes.Type(value=FilePathAnnotation.class, name="file_path")})
                    public static interface Annotation {
                        public int index();

                        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
                        public String type();

                        public String text();

                        public int startIndex();

                        public int endIndex();

                        public record FilePathAnnotation(int index, String text, FilePath filePath, int startIndex, int endIndex) implements Annotation
                        {
                            @Override
                            public String type() {
                                return "file_path";
                            }

                            public record FilePath(String fileId) {
                            }
                        }

                        public record FileCitationAnnotation(int index, String text, FileCitation fileCitation, int startIndex, int endIndex) implements Annotation
                        {
                            @Override
                            public String type() {
                                return "file_citation";
                            }

                            public record FileCitation(String fileId, String quote) {
                            }
                        }
                    }
                }
            }

            public record ImageUrlContent(int index, ImageUrl imageUrl) implements Content
            {
                @Override
                public String type() {
                    return "image_url";
                }

                public record ImageUrl(String url, Optional<String> detail) {
                }
            }

            public record ImageFileContent(int index, ImageFile imageFile) implements Content
            {
                @Override
                public String type() {
                    return "image_file";
                }

                public record ImageFile(String fileId, Optional<String> detail) {
                }
            }
        }
    }
}

