/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", include=JsonTypeInfo.As.EXISTING_PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=CodeInterpreterToolCall.class, name="code_interpreter"), @JsonSubTypes.Type(value=FileSearchToolCall.class, name="file_search"), @JsonSubTypes.Type(value=FunctionToolCall.class, name="function")})
public interface ToolCall {
    public String id();

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public String type();

    public static CodeInterpreterToolCall codeInterpreterToolCall(String id, CodeInterpreterToolCall.CodeInterpreter codeInterpreter) {
        return new CodeInterpreterToolCall(id, codeInterpreter);
    }

    public static FileSearchToolCall fileSearchToolCall(String id) {
        return new FileSearchToolCall(id, Collections.emptyMap());
    }

    public static FunctionToolCall functionToolCall(String id, FunctionToolCall.Function function) {
        return new FunctionToolCall(id, function);
    }

    public record CodeInterpreterToolCall(String id, CodeInterpreter codeInterpreter) implements ToolCall
    {
        @Override
        public String type() {
            return "code_interpreter";
        }

        public record CodeInterpreter(String input, List<Output> outputs) {

            /*
             * Uses 'sealed' constructs - enablewith --sealed true
             */
            @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", include=JsonTypeInfo.As.EXISTING_PROPERTY)
            @JsonSubTypes(value={@JsonSubTypes.Type(value=LogOutput.class, name="logs"), @JsonSubTypes.Type(value=ImageOutput.class, name="image")})
            public static interface Output {
                @JsonProperty(access=JsonProperty.Access.READ_ONLY)
                public String type();

                public static LogOutput logOutput(String logs) {
                    return new LogOutput(logs);
                }

                public static ImageOutput imageOutput(ImageOutput.Image image) {
                    return new ImageOutput(image);
                }

                public record LogOutput(String logs) implements Output
                {
                    @Override
                    public String type() {
                        return "logs";
                    }
                }

                public record ImageOutput(Image image) implements Output
                {
                    @Override
                    public String type() {
                        return "image";
                    }

                    public record Image(String fileId) {
                    }
                }
            }
        }
    }

    public record FileSearchToolCall(String id, Map<String, Object> fileSearch) implements ToolCall
    {
        @Override
        public String type() {
            return "file_search";
        }
    }

    public record FunctionToolCall(String id, Function function) implements ToolCall
    {
        @Override
        public String type() {
            return "function";
        }

        public record Function(String name, String arguments, String output) {
        }
    }
}

