/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.OpenAIModel;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;

public record TranscriptionRequest(Path file, String model, Optional<String> language, Optional<String> prompt, Optional<String> responseFormat, Optional<Double> temperature, Optional<List<String>> timestampGranularities) {
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private static final String DEFAULT_MODEL = OpenAIModel.WHISPER_1.getId();
        private Path file;
        private String model = DEFAULT_MODEL;
        private Optional<String> language = Optional.empty();
        private Optional<String> prompt = Optional.empty();
        private Optional<String> responseFormat = Optional.empty();
        private Optional<Double> temperature = Optional.empty();
        private Optional<List<String>> timestampGranularities = Optional.empty();

        public Builder file(Path file) {
            this.file = file;
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder model(OpenAIModel model) {
            this.model = model.getId();
            return this;
        }

        public Builder language(String language) {
            this.language = Optional.of(language);
            return this;
        }

        public Builder prompt(String prompt) {
            this.prompt = Optional.of(prompt);
            return this;
        }

        public Builder responseFormat(String responseFormat) {
            this.responseFormat = Optional.of(responseFormat);
            return this;
        }

        public Builder temperature(double temperature) {
            this.temperature = Optional.of(temperature);
            return this;
        }

        public Builder timestampGranularities(List<String> timestampGranularities) {
            this.timestampGranularities = Optional.of(timestampGranularities);
            return this;
        }

        public TranscriptionRequest build() {
            return new TranscriptionRequest(this.file, this.model, this.language, this.prompt, this.responseFormat, this.temperature, this.timestampGranularities);
        }
    }
}

