/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.CompleteUploadRequest;
import io.github.stefanbratanov.jvm.openai.CreateUploadRequest;
import io.github.stefanbratanov.jvm.openai.Endpoint;
import io.github.stefanbratanov.jvm.openai.MultipartBodyPublisher;
import io.github.stefanbratanov.jvm.openai.OpenAIClient;
import io.github.stefanbratanov.jvm.openai.Upload;
import io.github.stefanbratanov.jvm.openai.UploadPart;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;

public final class UploadsClient
extends OpenAIClient {
    private static final String PARTS_SEGMENT = "/parts";
    private static final String COMPLETE_SEGMENT = "/complete";
    private static final String CANCEL_SEGMENT = "/cancel";
    private final URI baseUrl;

    UploadsClient(URI baseUrl, String[] authenticationHeaders, HttpClient httpClient, Optional<Duration> requestTimeout) {
        super(authenticationHeaders, httpClient, requestTimeout);
        this.baseUrl = baseUrl;
    }

    public Upload createUpload(CreateUploadRequest request) {
        HttpRequest httpRequest = this.newHttpRequestBuilder("Content-Type", "application/json").uri(this.baseUrl.resolve(Endpoint.UPLOADS.getPath())).POST(this.createBodyPublisher(request)).build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), Upload.class);
    }

    public UploadPart addUploadPart(String uploadId, Path data) {
        MultipartBodyPublisher multipartBodyPublisher = MultipartBodyPublisher.newBuilder().filePart("data", data).build();
        HttpRequest httpRequest = this.newHttpRequestBuilder("Content-Type", multipartBodyPublisher.getContentTypeHeader()).uri(this.baseUrl.resolve(Endpoint.UPLOADS.getPath() + "/" + uploadId + PARTS_SEGMENT)).POST(multipartBodyPublisher).build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), UploadPart.class);
    }

    public Upload completeUpload(String uploadId, CompleteUploadRequest request) {
        HttpRequest httpRequest = this.newHttpRequestBuilder("Content-Type", "application/json").uri(this.baseUrl.resolve(Endpoint.UPLOADS.getPath() + "/" + uploadId + COMPLETE_SEGMENT)).POST(this.createBodyPublisher(request)).build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), Upload.class);
    }

    public Upload cancelUpload(String uploadId) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.UPLOADS.getPath() + "/" + uploadId + CANCEL_SEGMENT)).POST(HttpRequest.BodyPublishers.noBody()).build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), Upload.class);
    }
}

