/*
 * Decompiled with CFR 0.152.
 */
package io.github.stefanbratanov.jvm.openai;

import io.github.stefanbratanov.jvm.openai.CreateVectorStoreFileRequest;
import io.github.stefanbratanov.jvm.openai.DeletionStatus;
import io.github.stefanbratanov.jvm.openai.Endpoint;
import io.github.stefanbratanov.jvm.openai.OpenAIAssistantsClient;
import io.github.stefanbratanov.jvm.openai.PaginationQueryParameters;
import io.github.stefanbratanov.jvm.openai.VectorStoreFile;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

public final class VectorStoreFilesClient
extends OpenAIAssistantsClient {
    private static final String FILES_SEGMENT = "/files";
    private final URI baseUrl;

    VectorStoreFilesClient(URI baseUrl, String[] authenticationHeaders, HttpClient httpClient, Optional<Duration> requestTimeout) {
        super(authenticationHeaders, httpClient, requestTimeout);
        this.baseUrl = baseUrl;
    }

    public VectorStoreFile createVectorStoreFile(String vectorStoreId, CreateVectorStoreFileRequest request) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.VECTOR_STORES.getPath() + "/" + vectorStoreId + FILES_SEGMENT)).POST(this.createBodyPublisher(request)).build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), VectorStoreFile.class);
    }

    public PaginatedVectorStoreFiles listVectorStoreFiles(String vectorStoreId, PaginationQueryParameters paginationQueryParameters) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.VECTOR_STORES.getPath() + "/" + vectorStoreId + FILES_SEGMENT + this.createQueryParameters(paginationQueryParameters))).GET().build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), PaginatedVectorStoreFiles.class);
    }

    public VectorStoreFile retrieveVectorStoreFile(String vectorStoreId, String fileId) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.VECTOR_STORES.getPath() + "/" + vectorStoreId + "/files/" + fileId)).GET().build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), VectorStoreFile.class);
    }

    public DeletionStatus deleteVectorStoreFile(String vectorStoreId, String fileId) {
        HttpRequest httpRequest = this.newHttpRequestBuilder(new String[0]).uri(this.baseUrl.resolve(Endpoint.VECTOR_STORES.getPath() + "/" + vectorStoreId + "/files/" + fileId)).DELETE().build();
        HttpResponse<byte[]> httpResponse = this.sendHttpRequest(httpRequest);
        return this.deserializeResponse(httpResponse.body(), DeletionStatus.class);
    }

    public record PaginatedVectorStoreFiles(List<VectorStoreFile> data, String firstId, String lastId, boolean hasMore) {
    }
}

